/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.elc.attributes;

import java.util.Objects;
import java.util.function.Function;

public final class EValue<T> {
    private final T value;
    private final Function<T, String> serializer;

    public EValue(T value, Function<T, String> serializer) {
        this.value = value;
        this.serializer = serializer;
    }

    public String serialize() {
        return this.serializer.apply(this.value);
    }

    public static EValue<String> of(String value) {
        return EValue.of(value, Object::toString);
    }

    public static EValue<Boolean> of(boolean value) {
        return EValue.of(value, Object::toString);
    }

    public static EValue<Integer> of(int value) {
        return EValue.of(value, Object::toString);
    }

    public static <T extends Enum<T>> EValue<T> of(T value) {
        return EValue.of(value, Object::toString);
    }

    public static <T> EValue<T> of(T value, Function<T, String> serializer) {
        return new EValue<T>(value, serializer);
    }

    public String getTypeId() {
        if (this.value.getClass() == Integer.class) {
            return "intAttribute";
        }
        if (this.value.getClass() == Boolean.class) {
            return "booleanAttribute";
        }
        return "stringAttribute";
    }

    public String toString() {
        return "EValue[" + "value=" + this.value + "," + "serializer=" + this.serializer + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.serializer != null ? this.serializer.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((EValue)arg0).value, this.value)) {
            return false;
        }
        return Objects.equals(((EValue)arg0).serializer, this.serializer);
        {
        }
    }

    public T value() {
        return this.value;
    }

    public Function<T, String> serializer() {
        return this.serializer;
    }
}

