/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.minecraftdependencies;

import javax.inject.Inject;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;

abstract class DefaultValueDisambiguationRule<T>
implements AttributeDisambiguationRule<T> {
    private final T defaultValue;

    @Inject
    public DefaultValueDisambiguationRule(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void execute(MultipleCandidatesDetails<T> details) {
        Object consumerValue = details.getConsumerValue();
        if (consumerValue != null && details.getCandidateValues().contains(consumerValue)) {
            details.closestMatch(consumerValue);
        } else {
            for (Object candidateValue : details.getCandidateValues()) {
                if (!candidateValue.equals(this.defaultValue)) continue;
                details.closestMatch(candidateValue);
                return;
            }
        }
    }
}

