/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.nfrtgradle;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.IdeDetection;
import net.neoforged.moddevgradle.internal.utils.NetworkSettingPassthrough;
import net.neoforged.nfrtgradle.ArtifactManifestEntry;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.ApiStatus;

public abstract class NeoFormRuntimeTask
extends DefaultTask {
    private final SetProperty<ArtifactManifestEntry> artifactManifestEntries;
    private final ConfigurableFileCollection artifacts;

    @Classpath
    @InputFiles
    public abstract ConfigurableFileCollection getNeoFormRuntime();

    @Input
    @Optional
    public abstract Property<String> getLauncherManifestUrl();

    @Internal
    public abstract Property<Boolean> getVerbose();

    @Input
    @ApiStatus.Internal
    protected abstract Property<String> getJavaExecutable();

    @Inject
    @ApiStatus.Internal
    protected abstract JavaToolchainService getJavaToolchainService();

    @Inject
    @ApiStatus.Internal
    protected abstract ExecOperations getExecOperations();

    @Internal
    @ApiStatus.Internal
    protected abstract DirectoryProperty getHomeDirectory();

    @Internal
    @ApiStatus.Internal
    protected abstract DirectoryProperty getWorkDirectory();

    public NeoFormRuntimeTask() {
        Project project = this.getProject();
        File gradleHome = project.getGradle().getGradleUserHomeDir();
        File cacheDir = new File(gradleHome, "caches/neoformruntime");
        this.getHomeDirectory().set(cacheDir);
        this.getWorkDirectory().convention(project.getLayout().getBuildDirectory().dir("tmp/neoformruntime"));
        this.getJavaExecutable().convention(this.getJavaToolchainService().launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)21))).map(javaLauncher -> javaLauncher.getExecutablePath().getAsFile().getAbsolutePath()));
        this.artifactManifestEntries = project.getObjects().setProperty(ArtifactManifestEntry.class);
        this.getInputs().property("artifactManifestEntries", this.artifactManifestEntries);
        this.artifacts = project.files(new Object[0]);
        this.getInputs().property("artifacts", (Object)this.artifacts);
    }

    public final void run(List<String> args) {
        Set manifestEntries;
        ArrayList<String> realArgs = new ArrayList<String>(args);
        realArgs.add(0, "--home-dir");
        realArgs.add(1, ((Directory)this.getHomeDirectory().get()).getAsFile().getAbsolutePath());
        realArgs.add(2, "--work-dir");
        realArgs.add(3, ((Directory)this.getWorkDirectory().get()).getAsFile().getAbsolutePath());
        if (this.getLauncherManifestUrl().isPresent()) {
            realArgs.add("--launcher-meta-uri");
            realArgs.add((String)this.getLauncherManifestUrl().get());
        }
        if (((Boolean)this.getVerbose().get()).booleanValue()) {
            realArgs.add("--verbose");
        }
        if (!(manifestEntries = (Set)this.artifactManifestEntries.get()).isEmpty()) {
            File artifactManifest = this.writeArtifactManifest();
            realArgs.add("--artifact-manifest");
            realArgs.add(artifactManifest.getAbsolutePath());
            realArgs.add("--warn-on-artifact-manifest-miss");
        }
        if (IdeDetection.isIntelliJ()) {
            realArgs.add("--emojis");
        }
        this.getExecOperations().javaexec(execSpec -> {
            execSpec.systemProperties(NetworkSettingPassthrough.getNetworkSystemProperties());
            execSpec.jvmArgs(new Object[]{"-Dstdout.encoding=UTF-8", "-Dstderr.encoding=UTF-8"});
            execSpec.executable(this.getJavaExecutable().get());
            execSpec.classpath(new Object[]{this.getNeoFormRuntime()});
            execSpec.args((Iterable)realArgs);
        });
    }

    public final void addArtifactsToManifest(Configuration configuration) {
        this.artifactManifestEntries.addAll(configuration.getIncoming().getArtifacts().getResolvedArtifacts().map(results -> results.stream().map(ArtifactManifestEntry::new).collect(Collectors.toSet())));
        this.artifacts.from(new Object[]{configuration});
    }

    private File writeArtifactManifest() {
        Properties artifactsManifest = new Properties();
        for (ArtifactManifestEntry artifact : (Set)this.artifactManifestEntries.get()) {
            artifactsManifest.setProperty(artifact.artifactId(), artifact.file().getAbsolutePath());
        }
        File artifactManifest = new File(this.getTemporaryDir(), "nfrt_artifact_manifest.properties");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(artifactManifest));){
            artifactsManifest.store(out, "");
        }
        catch (IOException e) {
            throw new GradleException("Failed to write NFRT artifact manifest: " + String.valueOf(e), (Throwable)e);
        }
        return artifactManifest;
    }
}

