/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.minecraftdependencies;

import net.neoforged.minecraftdependencies.DistributionDisambiguationRule;
import net.neoforged.minecraftdependencies.MinecraftDistribution;
import net.neoforged.minecraftdependencies.OperatingSystem;
import net.neoforged.minecraftdependencies.OperatingSystemDisambiguationRule;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class MinecraftDependenciesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getDependencies().attributesSchema(attributesSchema -> {
            MinecraftDistribution defaultDistribution = (MinecraftDistribution)project.getObjects().named(MinecraftDistribution.class, "client");
            attributesSchema.attribute(MinecraftDistribution.ATTRIBUTE).getDisambiguationRules().add(DistributionDisambiguationRule.class, spec -> spec.params(new Object[]{defaultDistribution}));
            OperatingSystem defaultOperatingSystem = (OperatingSystem)project.getObjects().named(OperatingSystem.class, MinecraftDependenciesPlugin.getDefaultOperatingSystem());
            attributesSchema.attribute(OperatingSystem.ATTRIBUTE).getDisambiguationRules().add(OperatingSystemDisambiguationRule.class, spec -> spec.params(new Object[]{defaultOperatingSystem}));
        });
    }

    private static String getDefaultOperatingSystem() {
        return switch (net.neoforged.moddevgradle.internal.utils.OperatingSystem.current()) {
            default -> throw new IncompatibleClassChangeError();
            case net.neoforged.moddevgradle.internal.utils.OperatingSystem.LINUX -> "linux";
            case net.neoforged.moddevgradle.internal.utils.OperatingSystem.MACOS -> "osx";
            case net.neoforged.moddevgradle.internal.utils.OperatingSystem.WINDOWS -> "windows";
        };
    }
}

