/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.IdeDetection;
import net.neoforged.moddevgradle.internal.utils.NetworkSettingPassthrough;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.ExecOperations;

public abstract class NeoFormRuntimeTask
extends DefaultTask {
    @Internal
    abstract Property<Boolean> getVerbose();

    @Classpath
    @InputFiles
    abstract ConfigurableFileCollection getNeoFormRuntime();

    @InputFile
    @Optional
    abstract RegularFileProperty getArtifactManifestFile();

    @Input
    abstract Property<String> getJavaExecutable();

    @Inject
    protected abstract JavaToolchainService getJavaToolchainService();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Internal
    protected abstract DirectoryProperty getHomeDirectory();

    @Internal
    protected abstract DirectoryProperty getWorkDirectory();

    public NeoFormRuntimeTask() {
        Project project = this.getProject();
        this.getVerbose().convention((Object)false);
        File gradleHome = project.getGradle().getGradleUserHomeDir();
        File cacheDir = new File(gradleHome, "caches/neoformruntime");
        this.getHomeDirectory().set(cacheDir);
        this.getWorkDirectory().set(project.getLayout().getBuildDirectory().dir("tmp/neoformruntime"));
        this.getJavaExecutable().convention(this.getJavaToolchainService().launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)21))).map(javaLauncher -> javaLauncher.getExecutablePath().getAsFile().getAbsolutePath()));
    }

    protected void run(List<String> args) {
        ArrayList<String> realArgs = new ArrayList<String>(args);
        realArgs.add(0, "--home-dir");
        realArgs.add(1, ((Directory)this.getHomeDirectory().get()).getAsFile().getAbsolutePath());
        realArgs.add(2, "--work-dir");
        realArgs.add(3, ((Directory)this.getWorkDirectory().get()).getAsFile().getAbsolutePath());
        if (((Boolean)this.getVerbose().get()).booleanValue()) {
            realArgs.add("--verbose");
        }
        if (this.getArtifactManifestFile().isPresent()) {
            realArgs.add("--artifact-manifest");
            realArgs.add(((RegularFile)this.getArtifactManifestFile().get()).getAsFile().getAbsolutePath());
            realArgs.add("--warn-on-artifact-manifest-miss");
        }
        if (IdeDetection.isIntelliJ()) {
            realArgs.add("--emojis");
        }
        this.getExecOperations().javaexec(execSpec -> {
            execSpec.systemProperties(NetworkSettingPassthrough.getNetworkSystemProperties());
            execSpec.jvmArgs(new Object[]{"-Dstdout.encoding=UTF-8", "-Dstderr.encoding=UTF-8"});
            execSpec.executable(this.getJavaExecutable().get());
            execSpec.classpath(new Object[]{this.getNeoFormRuntime()});
            execSpec.args((Iterable)realArgs);
        });
    }
}

