/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.PrepareRunOrTest;
import net.neoforged.moddevgradle.internal.UserDevConfig;
import net.neoforged.moddevgradle.internal.UserDevRunType;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.Nullable;

abstract class PrepareRun
extends PrepareRunOrTest {
    @Input
    public abstract Property<String> getRunType();

    @Optional
    @Input
    public abstract Property<String> getMainClass();

    @Inject
    public PrepareRun() {
        super(PrepareRunOrTest.ProgramArgsFormat.JVM_ARGFILE);
    }

    @Override
    protected UserDevRunType resolveRunType(UserDevConfig userDevConfig) {
        if (((String)this.getRunType().get()).equals("junit")) {
            throw new GradleException("The junit run type cannot be used for normal NeoForge runs. Available run types: " + userDevConfig.runs().keySet());
        }
        UserDevRunType runConfig = userDevConfig.runs().get(this.getRunType().get());
        if (runConfig == null) {
            throw new GradleException("Trying to prepare unknown run: " + (String)this.getRunType().get() + ". Available run types: " + userDevConfig.runs().keySet());
        }
        return runConfig;
    }

    @Override
    @Nullable
    protected String resolveMainClass(UserDevRunType runConfig) {
        return (String)this.getMainClass().getOrElse((Object)runConfig.main());
    }

    @Override
    protected boolean isClientDistribution() {
        return ((String)this.getRunType().get()).equals("client") || ((String)this.getRunType().get()).equals("data");
    }
}

