/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class StringUtils {
    private static final Pattern NOT_LETTERS = Pattern.compile("\\P{L}");

    private StringUtils() {
    }

    public static String toCamelCase(String input, boolean lower) {
        int i;
        CharSequence[] parts = NOT_LETTERS.split(input);
        if (parts.length > 0 && lower) {
            parts[0] = StringUtils.uncapitalize(parts[0]);
        }
        int n = i = lower ? 1 : 0;
        while (i < parts.length) {
            parts[i] = StringUtils.capitalize((String)parts[i]);
            ++i;
        }
        return String.join((CharSequence)"", parts);
    }

    public static String capitalize(String input) {
        if (input.isEmpty()) {
            return "";
        }
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    public static String uncapitalize(String input) {
        if (input.isEmpty()) {
            return "";
        }
        return input.substring(0, 1).toLowerCase(Locale.ROOT) + input.substring(1);
    }
}

