/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.utils;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.Nullable;

public final class IdeDetection {
    private IdeDetection() {
    }

    public static boolean isIntelliJ() {
        return Boolean.getBoolean("idea.active");
    }

    public static boolean isIntelliJSync() {
        return Boolean.getBoolean("idea.sync.active");
    }

    public static boolean isEclipse() {
        return System.getProperty("eclipse.application") != null;
    }

    @Nullable
    public static File getIntellijProjectDir(Project project) {
        Gradle root = project.getGradle().getParent();
        if (root != null) {
            while (root.getParent() != null) {
                root = root.getParent();
            }
            return IdeDetection.getIntellijProjectDir(root.getRootProject().getProjectDir());
        }
        return IdeDetection.getIntellijProjectDir(project.getRootDir());
    }

    @Nullable
    private static File getIntellijProjectDir(File gradleProjectDir) {
        File ideaDir = new File(gradleProjectDir, ".idea");
        return ideaDir.exists() ? ideaDir : null;
    }
}

