/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal.jarjar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.ContainedJarIdentifier;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.VersionRange;
import net.neoforged.moddevgradle.internal.jarjar.ResolvedJarJarArtifact;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.jetbrains.annotations.Nullable;

public abstract class JarJarArtifacts {
    private final transient SetProperty<ResolvedComponentResult> includedRootComponents = this.getObjectFactory().setProperty(ResolvedComponentResult.class);
    private final transient SetProperty<ResolvedArtifactResult> includedArtifacts = this.getObjectFactory().setProperty(ResolvedArtifactResult.class);

    @Internal
    protected SetProperty<ResolvedComponentResult> getIncludedRootComponents() {
        return this.includedRootComponents;
    }

    @Internal
    protected SetProperty<ResolvedArtifactResult> getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Nested
    public abstract ListProperty<ResolvedJarJarArtifact> getResolvedArtifacts();

    public JarJarArtifacts() {
        this.includedArtifacts.finalizeValueOnRead();
        this.includedRootComponents.finalizeValueOnRead();
        this.getResolvedArtifacts().set(this.getIncludedRootComponents().zip(this.getIncludedArtifacts(), JarJarArtifacts::getIncludedJars));
    }

    public void configuration(Configuration jarJarConfiguration) {
        this.getIncludedArtifacts().addAll(jarJarConfiguration.getIncoming().artifactView(config -> config.attributes(attr -> attr.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar"))).getArtifacts().getResolvedArtifacts());
        this.getIncludedRootComponents().add(jarJarConfiguration.getIncoming().getResolutionResult().getRootComponent());
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        this.includedRootComponents.empty();
        this.includedArtifacts.empty();
        for (Configuration configuration : configurations) {
            this.configuration(configuration);
        }
    }

    private static List<ResolvedJarJarArtifact> getIncludedJars(Set<ResolvedComponentResult> rootComponents, Set<ResolvedArtifactResult> artifacts) {
        HashMap<ContainedJarIdentifier, String> versions = new HashMap<ContainedJarIdentifier, String>();
        HashMap<ContainedJarIdentifier, String> versionRanges = new HashMap<ContainedJarIdentifier, String>();
        HashSet<ContainedJarIdentifier> knownIdentifiers = new HashSet<ContainedJarIdentifier>();
        for (ResolvedComponentResult rootComponent : rootComponents) {
            JarJarArtifacts.collectFromComponent(rootComponent, knownIdentifiers, versions, versionRanges);
        }
        ArrayList<ResolvedJarJarArtifact> data = new ArrayList<ResolvedJarJarArtifact>();
        for (ResolvedArtifactResult result : artifacts) {
            ContainedJarIdentifier jarIdentifier;
            ResolvedVariantResult variant = result.getVariant();
            ArtifactIdentifier artifactIdentifier = JarJarArtifacts.capabilityOrModule(variant);
            if (artifactIdentifier == null || !knownIdentifiers.contains(jarIdentifier = new ContainedJarIdentifier(artifactIdentifier.group(), artifactIdentifier.name()))) continue;
            String version = versions.getOrDefault(jarIdentifier, JarJarArtifacts.getVersionFrom(variant));
            String versionRange = versionRanges.getOrDefault(jarIdentifier, JarJarArtifacts.makeOpenRange(variant));
            if (version == null || versionRange == null) continue;
            String embeddedFilename = JarJarArtifacts.getEmbeddedFilename(result, jarIdentifier);
            data.add(new ResolvedJarJarArtifact(result.getFile(), embeddedFilename, version, versionRange, jarIdentifier.group(), jarIdentifier.artifact()));
        }
        return data.stream().sorted(Comparator.comparing(d -> d.getGroup() + ":" + d.getArtifact())).collect(Collectors.toList());
    }

    private static String getEmbeddedFilename(ResolvedArtifactResult result, ContainedJarIdentifier jarIdentifier) {
        Object embeddedFilename = result.getFile().getName();
        if (result.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
            embeddedFilename = jarIdentifier.group() + "." + result.getFile().getName();
        }
        return embeddedFilename;
    }

    private static void collectFromComponent(ResolvedComponentResult rootComponent, Set<ContainedJarIdentifier> knownIdentifiers, Map<ContainedJarIdentifier, String> versions, Map<ContainedJarIdentifier, String> versionRanges) {
        for (DependencyResult result : rootComponent.getDependencies()) {
            String version;
            if (!(result instanceof ResolvedDependencyResult)) continue;
            ResolvedDependencyResult resolvedResult = (ResolvedDependencyResult)result;
            ComponentSelector requested = resolvedResult.getRequested();
            ResolvedVariantResult variant = resolvedResult.getResolvedVariant();
            ArtifactIdentifier artifactIdentifier = JarJarArtifacts.capabilityOrModule(variant);
            if (artifactIdentifier == null) continue;
            ContainedJarIdentifier jarIdentifier = new ContainedJarIdentifier(artifactIdentifier.group(), artifactIdentifier.name());
            knownIdentifiers.add(jarIdentifier);
            String versionRange = null;
            if (requested instanceof ModuleComponentSelector) {
                ModuleComponentSelector requestedModule = (ModuleComponentSelector)requested;
                VersionConstraint constraint = requestedModule.getVersionConstraint();
                versionRange = !constraint.getStrictVersion().isEmpty() ? JarJarArtifacts.validateVersionRange(constraint.getStrictVersion(), requestedModule) : (!constraint.getRequiredVersion().isEmpty() ? JarJarArtifacts.validateVersionRange(constraint.getRequiredVersion(), requestedModule) : (!constraint.getPreferredVersion().isEmpty() ? JarJarArtifacts.validateVersionRange(constraint.getPreferredVersion(), requestedModule) : JarJarArtifacts.validateVersionRange(requestedModule.getVersion(), requestedModule)));
            }
            if (versionRange == null) {
                versionRange = JarJarArtifacts.makeOpenRange(variant);
            }
            if ((version = JarJarArtifacts.getVersionFrom(variant)) != null) {
                versions.put(jarIdentifier, version);
            }
            if (versionRange == null) continue;
            versionRanges.put(jarIdentifier, versionRange);
        }
    }

    @Nullable
    private static ArtifactIdentifier capabilityOrModule(ResolvedVariantResult variant) {
        ArtifactIdentifier moduleIdentifier = null;
        ComponentIdentifier componentIdentifier = variant.getOwner();
        if (componentIdentifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)componentIdentifier;
            moduleIdentifier = new ArtifactIdentifier(moduleComponentIdentifier.getGroup(), moduleComponentIdentifier.getModule(), moduleComponentIdentifier.getVersion());
        }
        List<ArtifactIdentifier> capabilityIdentifiers = variant.getCapabilities().stream().map(capability -> new ArtifactIdentifier(capability.getGroup(), capability.getName(), capability.getVersion())).toList();
        if (moduleIdentifier != null && capabilityIdentifiers.contains(moduleIdentifier)) {
            return moduleIdentifier;
        }
        if (capabilityIdentifiers.isEmpty()) {
            return null;
        }
        return capabilityIdentifiers.get(0);
    }

    @Nullable
    private static String moduleOrCapabilityVersion(ResolvedVariantResult variant) {
        @Nullable ArtifactIdentifier identifier = JarJarArtifacts.capabilityOrModule(variant);
        if (identifier != null) {
            return identifier.version();
        }
        return null;
    }

    @Nullable
    private static String makeOpenRange(ResolvedVariantResult variant) {
        String baseVersion = JarJarArtifacts.moduleOrCapabilityVersion(variant);
        if (baseVersion == null) {
            return null;
        }
        return "[" + baseVersion + ",)";
    }

    @Nullable
    private static String getVersionFrom(ResolvedVariantResult variant) {
        return JarJarArtifacts.moduleOrCapabilityVersion(variant);
    }

    private static String validateVersionRange(String range, ModuleComponentSelector module) {
        VersionRange data;
        String errorPrefix = "Unsupported version constraint '" + range + "' on Jar-in-Jar dependency " + module.getModuleIdentifier() + ": ";
        try {
            data = VersionRange.createFromVersionSpec(range);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new GradleException(errorPrefix + e.getMessage());
        }
        if (!data.hasRestrictions()) {
            throw new GradleException(errorPrefix + "no restrictions");
        }
        if (data.getRecommendedVersion() != null) {
            throw new GradleException(errorPrefix + "recommended versions are unsupported");
        }
        if (range.contains("+")) {
            throw new GradleException(errorPrefix + "dynamic versions are unsupported");
        }
        return range;
    }

    private record ArtifactIdentifier(String group, String name, String version) {
    }
}

