/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import javax.inject.Inject;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.NeoForgeExtension;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.StringUtils;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.Dependencies;
import org.gradle.api.artifacts.dsl.DependencyCollector;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;
import org.slf4j.event.Level;

public abstract class RunModel
implements Named,
Dependencies {
    private final String name;
    final String baseName;
    private final Configuration configuration;

    @Inject
    public RunModel(String name, Project project) {
        this.name = name;
        this.baseName = StringUtils.toCamelCase(name, false);
        this.getMods().convention(((NeoForgeExtension)project.getExtensions().getByType(NeoForgeExtension.class)).getMods());
        this.getGameDirectory().convention(project.getLayout().getProjectDirectory().dir("run"));
        this.configuration = (Configuration)project.getConfigurations().create(InternalModelHelper.nameOfRun(this, "", "additionalRuntimeClasspath"), configuration -> {
            configuration.setCanBeResolved(false);
            configuration.setCanBeConsumed(false);
        });
        this.getLogLevel().convention((Object)Level.INFO);
        boolean isSubProject = project.getRootProject() != project;
        Object ideName = StringUtils.capitalize(name);
        if (isSubProject) {
            ideName = project.getName() + " - " + (String)ideName;
        }
        this.getIdeName().convention(ideName);
        this.getSourceSet().convention((Object)((SourceSet)ExtensionUtils.getSourceSets(project).getByName("main")));
    }

    public String getName() {
        return this.name;
    }

    public abstract Property<String> getIdeName();

    public abstract DirectoryProperty getGameDirectory();

    public abstract MapProperty<String, String> getEnvironment();

    public void environment(String key, String value) {
        this.getEnvironment().put((Object)key, (Object)value);
    }

    public abstract MapProperty<String, String> getSystemProperties();

    public void systemProperty(String key, String value) {
        this.getSystemProperties().put((Object)key, (Object)value);
    }

    public abstract Property<String> getMainClass();

    public abstract ListProperty<String> getProgramArguments();

    public void programArgument(String arg) {
        this.getProgramArguments().add((Object)arg);
    }

    public abstract ListProperty<String> getJvmArguments();

    public void jvmArgument(String arg) {
        this.getJvmArguments().add((Object)arg);
    }

    public abstract SetProperty<ModModel> getMods();

    public abstract Property<String> getType();

    public void client() {
        this.getType().set((Object)"client");
    }

    public void data() {
        this.getType().set((Object)"data");
    }

    public void server() {
        this.getType().set((Object)"server");
    }

    public Configuration getAdditionalRuntimeClasspathConfiguration() {
        return this.configuration;
    }

    public abstract DependencyCollector getAdditionalRuntimeClasspath();

    public abstract Property<Level> getLogLevel();

    public abstract Property<SourceSet> getSourceSet();

    public String toString() {
        return "Run[" + this.getName() + "]";
    }
}

