/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.net.URI;
import net.neoforged.moddevgradle.internal.generated.MojangRepositoryFilter;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.PluginAware;

public class RepositoriesPlugin
implements Plugin<PluginAware> {
    public void apply(PluginAware target) {
        if (target instanceof Project) {
            Project project = (Project)target;
            this.applyRepositories(project.getRepositories());
        } else if (target instanceof Settings) {
            Settings settings = (Settings)target;
            this.applyRepositories(settings.getDependencyResolutionManagement().getRepositories());
            settings.getGradle().getPlugins().apply(this.getClass());
        } else if (target instanceof Gradle) {
            Gradle gradle = (Gradle)target;
        } else {
            throw new GradleException("This plugin does not support being applied to " + target);
        }
    }

    private void applyRepositories(RepositoryHandler repositories) {
        MavenArtifactRepository mojangMaven = repositories.maven(repo -> {
            repo.setName("Mojang Minecraft Libraries");
            repo.setUrl(URI.create("https://libraries.minecraft.net/"));
            repo.metadataSources(sources -> sources.mavenPom());
            repo.content(MojangRepositoryFilter::filter);
        });
        RepositoriesPlugin.sortFirst(repositories, mojangMaven);
        MavenArtifactRepository mojangMetaMaven = repositories.maven(repo -> {
            repo.setName("Mojang Meta");
            repo.setUrl((Object)"https://maven.neoforged.net/mojang-meta/");
            repo.metadataSources(sources -> sources.gradleMetadata());
            repo.content(content -> content.includeModule("net.neoforged", "minecraft-dependencies"));
        });
        RepositoriesPlugin.sortFirst(repositories, mojangMetaMaven);
        repositories.maven(repo -> {
            repo.setName("NeoForged Releases");
            repo.setUrl(URI.create("https://maven.neoforged.net/releases/"));
        });
    }

    private static void sortFirst(RepositoryHandler repositories, MavenArtifactRepository repo) {
        repositories.remove((Object)repo);
        repositories.add(0, (Object)repo);
    }
}

