/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jetbrains.annotations.Nullable;

abstract class CreateEmptyRepoFilesValueSource
implements ValueSource<String, Params> {
    @Inject
    public CreateEmptyRepoFilesValueSource() {
    }

    @Nullable
    public String obtain() {
        Path repoDir = ((Directory)((Params)this.getParameters()).getRepoDirectory().get()).getAsFile().toPath();
        Path emptyJarFile = repoDir.resolve("minecraft/neoforge-minecraft-joined/local/neoforge-minecraft-joined-local.jar");
        try {
            Files.createDirectories(emptyJarFile.getParent(), new FileAttribute[0]);
            Files.createFile(emptyJarFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path pomFile = repoDir.resolve("minecraft/neoforge-minecraft-joined/local/neoforge-minecraft-joined-local.pom");
        try {
            Files.createDirectories(pomFile.getParent(), new FileAttribute[0]);
            Files.writeString(pomFile, (CharSequence)"<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n\n    <groupId>minecraft</groupId>\n    <artifactId>neoforge-minecraft-joined</artifactId>\n    <version>local</version>\n    <packaging>jar</packaging>\n</project>\n", StandardOpenOption.CREATE_NEW);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "";
    }

    static interface Params
    extends ValueSourceParameters {
        public DirectoryProperty getRepoDirectory();
    }
}

