/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.TreeSet;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

abstract class WriteLegacyClasspath
extends DefaultTask {
    @Inject
    public WriteLegacyClasspath() {
    }

    @InputFiles
    abstract ConfigurableFileCollection getEntries();

    @OutputFile
    abstract RegularFileProperty getLegacyClasspathFile();

    @TaskAction
    public void writeLegacyClasspath() throws IOException {
        StringBuilder legacyClasspath = new StringBuilder();
        for (File entry : new TreeSet(this.getEntries().getFiles())) {
            legacyClasspath.append(entry.getAbsolutePath()).append(System.lineSeparator());
        }
        Path destination = ((File)this.getLegacyClasspathFile().getAsFile().get()).toPath();
        FileUtils.writeStringSafe(destination, legacyClasspath.toString());
    }
}

