/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.moddevgradle.internal.AssetProperties;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.UserDevConfig;
import net.neoforged.moddevgradle.internal.UserDevRunType;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;

abstract class PrepareRunOrTest
extends DefaultTask {
    private final ProgramArgsFormat programArgsFormat;

    @Internal
    public abstract DirectoryProperty getGameDirectory();

    @OutputFile
    public abstract RegularFileProperty getVmArgsFile();

    @OutputFile
    public abstract RegularFileProperty getProgramArgsFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getLog4jConfigFile();

    @Classpath
    public abstract ConfigurableFileCollection getNeoForgeModDevConfig();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getAssetProperties();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    abstract RegularFileProperty getLegacyClasspathFile();

    @Classpath
    @InputFiles
    abstract ConfigurableFileCollection getModules();

    @Input
    public abstract MapProperty<String, String> getSystemProperties();

    @Input
    public abstract ListProperty<String> getJvmArguments();

    @Input
    public abstract ListProperty<String> getProgramArguments();

    @Input
    public abstract Property<Level> getGameLogLevel();

    protected PrepareRunOrTest(ProgramArgsFormat programArgsFormat) {
        this.programArgsFormat = programArgsFormat;
    }

    protected abstract UserDevRunType resolveRunType(UserDevConfig var1);

    @Nullable
    protected abstract String resolveMainClass(UserDevRunType var1);

    private List<String> getInterpolatedJvmArgs(UserDevRunType runConfig) {
        ArrayList<String> result = new ArrayList<String>();
        for (String jvmArg : runConfig.jvmArgs()) {
            String arg = jvmArg;
            if (arg.equals("{modules}")) {
                arg = this.getModules().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            }
            result.add(RunUtils.escapeJvmArg(arg));
        }
        return result;
    }

    @TaskAction
    public void prepareRun() throws IOException {
        UserDevRunType runConfig;
        File runDir = ((Directory)this.getGameDirectory().get()).getAsFile();
        Files.createDirectories(runDir.toPath(), new FileAttribute[0]);
        if (this.getNeoForgeModDevConfig().isEmpty()) {
            runConfig = this.resolveRunType(this.getSimulatedUserDevConfigForVanilla());
        } else {
            UserDevConfig userDevConfig = UserDevConfig.from(this.getNeoForgeModDevConfig().getSingleFile());
            runConfig = this.resolveRunType(userDevConfig);
        }
        this.writeJvmArguments(runConfig);
        this.writeProgramArguments(runConfig);
    }

    private UserDevConfig getSimulatedUserDevConfigForVanilla() {
        List<String> clientArgs = List.of("--gameDir", ".", "--assetIndex", "{asset_index}", "--assetsDir", "{assets_root}", "--accessToken", "NotValid", "--version", "ModDevGradle");
        List<String> commonArgs = List.of();
        return new UserDevConfig("", "", "", List.of(), List.of(), Map.of("client", new UserDevRunType(true, "net.minecraft.client.main.Main", clientArgs, List.of(), true, false, false, false, Map.of(), Map.of()), "server", new UserDevRunType(true, "net.minecraft.server.Main", commonArgs, List.of(), false, true, false, false, Map.of(), Map.of()), "data", new UserDevRunType(true, "net.minecraft.data.Main", commonArgs, List.of(), false, false, true, false, Map.of(), Map.of())));
    }

    private void writeJvmArguments(UserDevRunType runConfig) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.getInterpolatedJvmArgs(runConfig));
        List userJvmArgs = (List)this.getJvmArguments().get();
        if (!userJvmArgs.isEmpty()) {
            lines.add("");
            lines.add("# User JVM Arguments");
            for (String string : userJvmArgs) {
                lines.add(RunUtils.escapeJvmArg(string));
            }
            lines.add("");
        }
        if (this.getLog4jConfigFile().isPresent()) {
            File log4jConfigFile = ((RegularFile)this.getLog4jConfigFile().get()).getAsFile();
            RunUtils.writeLog4j2Configuration((Level)this.getGameLogLevel().get(), log4jConfigFile.toPath());
            lines.add(RunUtils.escapeJvmArg("-Dlog4j2.configurationFile=" + log4jConfigFile.getAbsolutePath()));
        }
        for (Map.Entry<String, String> entry : runConfig.props().entrySet()) {
            String propValue = entry.getValue();
            if (propValue.equals("{minecraft_classpath_file}")) {
                propValue = ((File)this.getLegacyClasspathFile().getAsFile().get()).getAbsolutePath();
            }
            PrepareRunOrTest.addSystemProp(entry.getKey(), propValue, lines);
        }
        for (Map.Entry<String, String> entry : ((Map)this.getSystemProperties().get()).entrySet()) {
            PrepareRunOrTest.addSystemProp(entry.getKey(), entry.getValue(), lines);
        }
        FileUtils.writeLinesSafe(((RegularFile)this.getVmArgsFile().get()).getAsFile().toPath(), lines);
    }

    private void writeProgramArguments(UserDevRunType runConfig) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String mainClass = this.resolveMainClass(runConfig);
        if (mainClass != null) {
            lines.add("# Main Class");
            lines.add(mainClass);
            lines.add("");
        }
        lines.add("# NeoForge Run-Type Program Arguments");
        AssetProperties assetProperties = RunUtils.loadAssetProperties(((RegularFile)this.getAssetProperties().get()).getAsFile());
        List<String> args = runConfig.args();
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg = switch (arg = iterator.next()) {
                case "{assets_root}" -> Objects.requireNonNull(assetProperties.assetsRoot(), "assets_root");
                case "{asset_index}" -> Objects.requireNonNull(assetProperties.assetIndex(), "asset_index");
            };
            if (this.programArgsFormat == ProgramArgsFormat.FML_JUNIT) {
                lines.add(arg);
                continue;
            }
            lines.add(RunUtils.escapeJvmArg(arg));
        }
        lines.add("");
        lines.add("# User Supplied Program Arguments");
        for (String arg : (List)this.getProgramArguments().get()) {
            if (this.programArgsFormat == ProgramArgsFormat.FML_JUNIT) {
                lines.add(arg);
                continue;
            }
            lines.add(RunUtils.escapeJvmArg(arg));
        }
        if (this.programArgsFormat == ProgramArgsFormat.FML_JUNIT) {
            lines.removeIf(line -> (line = line.strip()).isEmpty() || line.startsWith("#"));
        }
        FileUtils.writeLinesSafe(((RegularFile)this.getProgramArgsFile().get()).getAsFile().toPath(), lines);
    }

    private static void addSystemProp(String name, String value, List<String> lines) {
        lines.add(RunUtils.escapeJvmArg("-D" + name + "=" + value));
    }

    protected static enum ProgramArgsFormat {
        JVM_ARGFILE,
        FML_JUNIT;

    }
}

