/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.neoforged.elc.configs.JavaApplicationLaunchConfig;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.NeoForgeExtension;
import net.neoforged.moddevgradle.dsl.NeoFormRuntime;
import net.neoforged.moddevgradle.dsl.Parchment;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.dsl.UnitTest;
import net.neoforged.moddevgradle.internal.ArtifactManifestEntry;
import net.neoforged.moddevgradle.internal.CreateArtifactManifestTask;
import net.neoforged.moddevgradle.internal.CreateMinecraftArtifactsTask;
import net.neoforged.moddevgradle.internal.DistributionDisambiguation;
import net.neoforged.moddevgradle.internal.DownloadAssetsTask;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.NeoFormRuntimeEngineTask;
import net.neoforged.moddevgradle.internal.OperatingSystemDisambiguation;
import net.neoforged.moddevgradle.internal.PrepareRun;
import net.neoforged.moddevgradle.internal.PrepareTest;
import net.neoforged.moddevgradle.internal.RepositoriesPlugin;
import net.neoforged.moddevgradle.internal.RunGameTask;
import net.neoforged.moddevgradle.internal.RunUtils;
import net.neoforged.moddevgradle.internal.WriteLegacyClasspath;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.FileUtils;
import net.neoforged.moddevgradle.internal.utils.IdeDetection;
import net.neoforged.moddevgradle.tasks.JarJar;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.ext.Application;
import org.jetbrains.gradle.ext.IdeaExtPlugin;
import org.jetbrains.gradle.ext.JUnit;
import org.jetbrains.gradle.ext.ModuleRef;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.RunConfigurationContainer;
import org.slf4j.event.Level;

public class ModDevPlugin
implements Plugin<Project> {
    private static final Attribute<String> ATTRIBUTE_DISTRIBUTION = Attribute.of((String)"net.neoforged.distribution", String.class);
    private static final Attribute<String> ATTRIBUTE_OPERATING_SYSTEM = Attribute.of((String)"net.neoforged.operatingsystem", String.class);
    private static final String JUNIT_GAME_DIR = "build/minecraft-junit";
    private static final String JAR_JAR_GROUP = "jarjar";
    private static final String TASK_GROUP = "mod development";
    private static final String INTERNAL_TASK_GROUP = "mod development/internal";
    public static final String CONFIGURATION_RUNTIME_DEPENDENCIES = "neoForgeRuntimeDependencies";
    public static final String CONFIGURATION_COMPILE_DEPENDENCIES = "neoForgeCompileDependencies";
    private Runnable configureTesting = null;

    public void apply(Project project) {
        project.getPlugins().apply(JavaLibraryPlugin.class);
        if (!project.getGradle().getPlugins().hasPlugin(RepositoriesPlugin.class)) {
            project.getPlugins().apply(RepositoriesPlugin.class);
        } else {
            project.getLogger().info("Not enabling NeoForged repositories since they were applied at the settings level");
        }
        JavaPluginExtension javaExtension = ExtensionUtils.getExtension((ExtensionAware)project, "java", JavaPluginExtension.class);
        ConfigurationContainer configurations = project.getConfigurations();
        ProjectLayout layout = project.getLayout();
        TaskContainer tasks = project.getTasks();
        Provider modDevBuildDir = layout.getBuildDirectory().dir("moddev");
        NeoForgeExtension extension = (NeoForgeExtension)project.getExtensions().create("neoForge", NeoForgeExtension.class, new Object[0]);
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        Provider hasNeoForge = extension.getVersion().map(ignored -> true).orElse((Object)false);
        Provider neoForgeModDevLibrariesDependency = extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + version)).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies"))).orElse(extension.getNeoFormVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoform:" + version)).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies"))));
        project.getDependencies().attributesSchema(attributesSchema -> {
            attributesSchema.attribute(ATTRIBUTE_DISTRIBUTION).getDisambiguationRules().add(DistributionDisambiguation.class);
            attributesSchema.attribute(ATTRIBUTE_OPERATING_SYSTEM).getDisambiguationRules().add(OperatingSystemDisambiguation.class);
        });
        TaskProvider createManifest = tasks.register("createArtifactManifest", CreateArtifactManifestTask.class, task -> {
            task.setGroup(INTERNAL_TASK_GROUP);
            task.setDescription("Creates the NFRT manifest file, containing all dependencies needed to setup the MC artifacts and downloading them in the process.");
            this.configureArtifactManifestTask((CreateArtifactManifestTask)((Object)task), extension);
            task.getManifestFile().set(modDevBuildDir.map(dir -> dir.file("nfrt_artifact_manifest.properties")));
        });
        Configuration neoFormRuntimeConfig = (Configuration)configurations.create("neoFormRuntime", spec -> {
            spec.setDescription("The NeoFormRuntime CLI tool");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.defaultDependencies(dependencies -> dependencies.addLater(extension.getNeoFormRuntime().getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoform-runtime:" + version)).attributes(attributes -> attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "shadowed")))))));
        });
        Configuration accessTransformers = (Configuration)configurations.create("accessTransformers", spec -> {
            spec.setDescription("AccessTransformers to widen visibility of Minecraft classes/fields/methods");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.defaultDependencies(dependencies -> dependencies.addLater(extension.getAccessTransformers().map(xva$0 -> project.files(new Object[]{xva$0})).map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0))));
        });
        Parchment parchment = extension.getParchment();
        Configuration parchmentData = (Configuration)configurations.create("parchmentData", spec -> {
            spec.setDescription("Data used to add parameter names and javadoc to Minecraft sources");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.setTransitive(false);
            spec.withDependencies(dependencies -> dependencies.addLater(parchment.getParchmentArtifact().map(arg_0 -> ((DependencyFactory)project.getDependencyFactory()).create(arg_0))));
        });
        Consumer<NeoFormRuntimeEngineTask> configureEngineTask = task -> {
            NeoFormRuntime nfrtSettings = extension.getNeoFormRuntime();
            task.getVerbose().set(nfrtSettings.getVerbose());
            task.getEnableCache().set(nfrtSettings.getEnableCache());
            task.getAnalyzeCacheMisses().set(nfrtSettings.getAnalyzeCacheMisses());
            task.getUseEclipseCompiler().set(nfrtSettings.getUseEclipseCompiler());
            task.getArtifactManifestFile().set((Provider)((CreateArtifactManifestTask)((Object)((Object)createManifest.get()))).getManifestFile());
            task.getNeoForgeArtifact().set(extension.getVersion().map(version -> "net.neoforged:neoforge:" + version));
            task.getNeoFormArtifact().set(extension.getNeoFormVersion().map(version -> "net.neoforged:neoform:" + version + "@zip"));
            task.getNeoFormRuntime().from(new Object[]{neoFormRuntimeConfig});
        };
        TaskProvider createArtifacts = tasks.register("createMinecraftArtifacts", CreateMinecraftArtifactsTask.class, task -> {
            task.setGroup(INTERNAL_TASK_GROUP);
            task.setDescription("Creates the NeoForge and Minecraft artifacts by invoking NFRT.");
            task.getAccessTransformers().from(new Object[]{accessTransformers});
            task.getParchmentData().from(new Object[]{parchmentData});
            Provider minecraftArtifactsDir = modDevBuildDir.map(dir -> dir.dir("artifacts"));
            task.getCompiledArtifact().set(minecraftArtifactsDir.map(dir -> dir.file("neoforge-minecraft-joined-local.jar")));
            task.getCompiledWithSourcesArtifact().set(minecraftArtifactsDir.map(dir -> dir.file("neoforge-minecraft-joined-local-merged.jar")));
            task.getSourcesArtifact().set(minecraftArtifactsDir.map(dir -> dir.file("neoforge-minecraft-joined-local-sources.jar")));
            task.getResourcesArtifact().set(minecraftArtifactsDir.map(dir -> dir.file("neoforge-minecraft-joined-local-resources-aka-client-extra.jar")));
            configureEngineTask.accept((NeoFormRuntimeEngineTask)((Object)task));
        });
        TaskProvider downloadAssets = tasks.register("downloadAssets", DownloadAssetsTask.class, task -> {
            task.setGroup(TASK_GROUP);
            task.setDescription("Downloads the Minecraft assets and asset index needed to run a Minecraft client or generate client-side resources.");
            task.getAssetPropertiesFile().set(modDevBuildDir.map(dir -> dir.file("minecraft_assets.properties")));
            configureEngineTask.accept((NeoFormRuntimeEngineTask)((Object)task));
        });
        Provider minecraftClassesArtifact = ModDevPlugin.shouldUseCombinedSourcesAndClassesArtifact() ? createArtifacts.map(task -> project.files(new Object[]{task.getCompiledWithSourcesArtifact()})) : createArtifacts.map(task -> project.files(new Object[]{task.getCompiledArtifact()}));
        Configuration runtimeDependenciesConfig = (Configuration)configurations.create(CONFIGURATION_RUNTIME_DEPENDENCIES, config -> {
            config.setDescription("The runtime dependencies to develop a mod for NeoForge, including Minecraft classes.");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.withDependencies(dependencies -> {
                dependencies.addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
                dependencies.addLater(createArtifacts.map(task -> project.files(new Object[]{task.getResourcesArtifact()})).map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
                dependencies.addLater(neoForgeModDevLibrariesDependency);
                dependencies.add((Object)dependencyFactory.create((CharSequence)RunUtils.DEV_LAUNCH_GAV));
            });
        });
        configurations.create(CONFIGURATION_COMPILE_DEPENDENCIES, config -> {
            config.setDescription("The compile-time dependencies to develop a mod for NeoForge, including Minecraft classes.");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.withDependencies(dependencies -> {
                dependencies.addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
                dependencies.addLater(neoForgeModDevLibrariesDependency);
            });
        });
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        extension.addModdingDependenciesTo((SourceSet)sourceSets.getByName("main"));
        configurations.named("compileOnly").configure(configuration -> configuration.withDependencies(dependencies -> {
            dependencies.addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
            dependencies.addLater(neoForgeModDevLibrariesDependency);
        }));
        project.afterEvaluate(ignored -> {
            JavaToolchainSpec toolchainSpec = javaExtension.getToolchain();
            try {
                toolchainSpec.getLanguageVersion().convention((Object)JavaLanguageVersion.of((int)21));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        Configuration userDevConfigOnly = (Configuration)project.getConfigurations().create("neoForgeConfigOnly", spec -> {
            spec.setDescription("Resolves exclusively the NeoForge userdev JSON for configuring runs");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.setTransitive(false);
            spec.withDependencies(set -> set.addLater(extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + version)).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-config")))));
        });
        TaskProvider ideSyncTask = tasks.register("neoForgeIdeSync", task -> {
            task.setDescription("A utility task that is used to create necessary files when the Gradle project is synchronized with the IDE project.");
            task.dependsOn(new Object[]{createArtifacts});
        });
        IdentityHashMap<RunModel, TaskProvider<PrepareRun>> prepareRunTasks = new IdentityHashMap<RunModel, TaskProvider<PrepareRun>>();
        extension.getRuns().configureEach(run -> {
            Provider<String> type = RunUtils.getRequiredType(project, run);
            Provider runtimeClasspathConfig = run.getSourceSet().map(sourceSet -> sourceSet.getRuntimeClasspathConfigurationName()).map(name -> configurations.getByName(name));
            Configuration neoForgeModDevModules = (Configuration)project.getConfigurations().create(InternalModelHelper.nameOfRun(run, "", "modulesOnly"), spec -> {
                spec.setDescription("Libraries that should be placed on the JVMs boot module path for run " + run.getName() + ".");
                spec.setCanBeResolved(true);
                spec.setCanBeConsumed(false);
                spec.shouldResolveConsistentlyWith((Configuration)runtimeClasspathConfig.get());
                spec.withDependencies(set -> {
                    set.addLater(extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + version)).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-module-path")).exclude(Map.of("group", "org.jetbrains", "module", "annotations"))));
                    set.add((Object)dependencyFactory.create((CharSequence)RunUtils.DEV_LAUNCH_GAV));
                });
            });
            Configuration legacyClasspathConfiguration = (Configuration)configurations.create(InternalModelHelper.nameOfRun(run, "", "legacyClasspath"), spec -> {
                spec.setDescription("Contains all dependencies of the " + run.getName() + " run that should not be considered boot classpath modules.");
                spec.setCanBeResolved(true);
                spec.setCanBeConsumed(false);
                spec.shouldResolveConsistentlyWith((Configuration)runtimeClasspathConfig.get());
                spec.attributes(attributes -> {
                    attributes.attributeProvider(ATTRIBUTE_DISTRIBUTION, type.map(t -> t.equals("client") || t.equals("data") ? "client" : "server"));
                    attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
                });
                spec.withDependencies(set -> set.addLater(neoForgeModDevLibrariesDependency));
                spec.extendsFrom(new Configuration[]{run.getAdditionalRuntimeClasspathConfiguration()});
                spec.getDependencies().addAllLater(run.getAdditionalRuntimeClasspath().getDependencies());
            });
            TaskProvider writeLcpTask = tasks.register(InternalModelHelper.nameOfRun(run, "write", "legacyClasspath"), WriteLegacyClasspath.class, writeLcp -> {
                writeLcp.setGroup(INTERNAL_TASK_GROUP);
                writeLcp.setDescription("Writes the legacyClasspath file for the " + run.getName() + " Minecraft run, containing all dependencies that shouldn't be considered boot modules.");
                writeLcp.getLegacyClasspathFile().convention(modDevBuildDir.map(dir -> dir.file(InternalModelHelper.nameOfRun(run, "", "legacyClasspath") + ".txt")));
                writeLcp.getEntries().from(new Object[]{legacyClasspathConfiguration});
                writeLcp.getEntries().from(new Object[]{((CreateMinecraftArtifactsTask)((Object)((Object)((Object)createArtifacts.get())))).getResourcesArtifact()});
            });
            TaskProvider prepareRunTask = tasks.register(InternalModelHelper.nameOfRun(run, "prepare", "run"), PrepareRun.class, task -> {
                task.setGroup(INTERNAL_TASK_GROUP);
                task.setDescription("Prepares all files needed to launch the " + run.getName() + " Minecraft run.");
                task.getGameDirectory().set((Provider)run.getGameDirectory());
                task.getVmArgsFile().set(RunUtils.getArgFile((Provider<Directory>)modDevBuildDir, run, RunUtils.RunArgFile.VMARGS));
                task.getProgramArgsFile().set(RunUtils.getArgFile((Provider<Directory>)modDevBuildDir, run, RunUtils.RunArgFile.PROGRAMARGS));
                task.getLog4jConfigFile().set(RunUtils.getArgFile((Provider<Directory>)modDevBuildDir, run, RunUtils.RunArgFile.LOG4J_CONFIG));
                task.getRunType().set(run.getType());
                task.getNeoForgeModDevConfig().from(new Object[]{userDevConfigOnly});
                task.getModules().from(new Object[]{neoForgeModDevModules});
                task.getLegacyClasspathFile().set((Provider)((WriteLegacyClasspath)((Object)((Object)((Object)writeLcpTask.get())))).getLegacyClasspathFile());
                task.getAssetProperties().set(downloadAssets.flatMap(DownloadAssetsTask::getAssetPropertiesFile));
                task.getSystemProperties().set(run.getSystemProperties().map(props -> {
                    props = new HashMap(props);
                    return props;
                }));
                task.getMainClass().set(run.getMainClass());
                task.getProgramArguments().set(run.getProgramArguments());
                task.getJvmArguments().set(run.getJvmArguments());
                task.getGameLogLevel().set(run.getLogLevel());
            });
            prepareRunTasks.put((RunModel)run, (TaskProvider<PrepareRun>)prepareRunTask);
            ideSyncTask.configure(task -> task.dependsOn(new Object[]{prepareRunTask}));
            tasks.register(InternalModelHelper.nameOfRun(run, "run", ""), RunGameTask.class, task -> {
                task.setGroup(TASK_GROUP);
                task.setDescription("Runs the " + run.getName() + " Minecraft run configuration.");
                JavaToolchainService toolchainService = ExtensionUtils.findExtension((ExtensionAware)project, "javaToolchains", JavaToolchainService.class);
                task.getJavaLauncher().set(toolchainService.launcherFor(spec -> spec.getLanguageVersion().set((Provider)javaExtension.getToolchain().getLanguageVersion())));
                task.getClasspathProvider().from(new Object[]{run.getSourceSet().map(SourceSet::getRuntimeClasspath)});
                task.getGameDirectory().set((Provider)run.getGameDirectory());
                task.getEnvironmentProperty().set(run.getEnvironment());
                task.jvmArgs(new Object[]{RunUtils.getArgFileParameter((RegularFile)((PrepareRun)((Object)((Object)((Object)prepareRunTask.get())))).getVmArgsFile().get()).replace("\\", "\\\\")});
                task.getMainClass().set((Object)RunUtils.DEV_LAUNCH_MAIN_CLASS);
                task.args(new Object[]{RunUtils.getArgFileParameter((RegularFile)((PrepareRun)((Object)((Object)((Object)prepareRunTask.get())))).getProgramArgsFile().get()).replace("\\", "\\\\")});
                task.dependsOn(new Object[]{prepareRunTask});
                task.getJvmArgumentProviders().add(RunUtils.getGradleModFoldersProvider(project, run.getMods(), false));
            });
        });
        ModDevPlugin.setupJarJar(project);
        this.configureTesting = () -> this.setupTesting(project, (Provider<Directory>)modDevBuildDir, userDevConfigOnly, (TaskProvider<DownloadAssetsTask>)downloadAssets, (TaskProvider<Task>)ideSyncTask, (TaskProvider<CreateMinecraftArtifactsTask>)createArtifacts, (Provider<ModuleDependency>)neoForgeModDevLibrariesDependency, (Provider<ConfigurableFileCollection>)minecraftClassesArtifact);
        ModDevPlugin.configureIntelliJModel(project, (TaskProvider<Task>)ideSyncTask, extension, prepareRunTasks);
        ModDevPlugin.configureEclipseModel(project, (TaskProvider<Task>)ideSyncTask, (TaskProvider<CreateMinecraftArtifactsTask>)createArtifacts, extension, prepareRunTasks);
    }

    private void configureArtifactManifestTask(CreateArtifactManifestTask task, NeoForgeExtension extension) {
        Project project = task.getProject();
        ConfigurationContainer configurations = project.getConfigurations();
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        String configurationPrefix = "neoFormRuntimeDependencies";
        Provider neoForgeDependency = extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + version)));
        Provider neoFormDependency = extension.getNeoFormVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoform:" + version)));
        Configuration neoForgeClassesAndData = (Configuration)configurations.create(configurationPrefix + "NeoForgeClasses", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (NeoForge classes)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.withDependencies(depSpec -> depSpec.addLater(neoForgeDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-bundle")))));
            spec.withDependencies(depSpec -> depSpec.addLater(neoFormDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform")))));
        });
        Configuration neoForgeSources = (Configuration)configurations.create(configurationPrefix + "NeoForgeSources", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (NeoForge sources)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.withDependencies(depSpec -> depSpec.addLater(neoForgeDependency));
            spec.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "documentation")));
                attributes.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)project.getObjects().named(DocsType.class, "sources")));
            });
        });
        Configuration compileClasspath = (Configuration)configurations.create(configurationPrefix + "CompileClasspath", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (Classpath)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.withDependencies(depSpec -> depSpec.addLater(neoForgeDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies")))));
            spec.withDependencies(depSpec -> depSpec.addLater(neoFormDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoform-dependencies")))));
            spec.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-api")));
                attributes.attribute(ATTRIBUTE_DISTRIBUTION, (Object)"client");
            });
        });
        Configuration runtimeClasspath = (Configuration)configurations.create(configurationPrefix + "RuntimeClasspath", spec -> {
            spec.setDescription("Dependencies needed for running NeoFormRuntime for the selected NeoForge/NeoForm version (Classpath)");
            spec.setCanBeConsumed(false);
            spec.setCanBeResolved(true);
            spec.withDependencies(depSpec -> {
                depSpec.addLater(neoForgeDependency);
                depSpec.addLater(neoForgeDependency.map(dependency -> dependency.copy().capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-dependencies"))));
            });
            spec.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
                attributes.attribute(ATTRIBUTE_DISTRIBUTION, (Object)"client");
            });
        });
        for (Configuration configuration : List.of(neoForgeClassesAndData, neoForgeSources, compileClasspath, runtimeClasspath)) {
            task.getNeoForgeModDevArtifacts().addAll(configuration.getIncoming().getArtifacts().getResolvedArtifacts().map(results -> results.stream().map(result -> {
                String gav = ModDevPlugin.guessMavenGav(result);
                return new ArtifactManifestEntry(gav, result.getFile());
            }).collect(Collectors.toSet())));
        }
    }

    private static boolean shouldUseCombinedSourcesAndClassesArtifact() {
        return IdeDetection.isIntelliJ();
    }

    public void setupTesting() {
        if (this.configureTesting == null) {
            throw new IllegalStateException("Unit testing was already enabled once!");
        }
        this.configureTesting.run();
        this.configureTesting = null;
    }

    private void setupTesting(Project project, Provider<Directory> modDevDir, Configuration userDevConfigOnly, TaskProvider<DownloadAssetsTask> downloadAssets, TaskProvider<Task> ideSyncTask, TaskProvider<CreateMinecraftArtifactsTask> createArtifacts, Provider<ModuleDependency> neoForgeModDevLibrariesDependency, Provider<ConfigurableFileCollection> minecraftClassesArtifact) {
        NeoForgeExtension extension = ExtensionUtils.getExtension((ExtensionAware)project, "neoForge", NeoForgeExtension.class);
        UnitTest unitTest = extension.getUnitTest();
        File gameDirectory = new File(project.getProjectDir(), JUNIT_GAME_DIR);
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        DependencyFactory dependencyFactory = project.getDependencyFactory();
        configurations.named("testCompileOnly").configure(configuration -> configuration.withDependencies(dependencies -> {
            dependencies.addLater(minecraftClassesArtifact.map(arg_0 -> ((DependencyFactory)dependencyFactory).create(arg_0)));
            dependencies.addLater(neoForgeModDevLibrariesDependency);
        }));
        Configuration testFixtures = (Configuration)configurations.create("neoForgeTestFixtures", config -> {
            config.setDescription("Additional JUnit helpers provided by NeoForge");
            config.setCanBeResolved(false);
            config.setCanBeConsumed(false);
            config.withDependencies(dependencies -> dependencies.addLater(extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + version)).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-test-fixtures")))));
        });
        NamedDomainObjectProvider testRuntimeClasspathConfig = configurations.named("testRuntimeClasspath", files -> {
            files.extendsFrom(new Configuration[]{configurations.getByName(CONFIGURATION_RUNTIME_DEPENDENCIES)});
            files.extendsFrom(new Configuration[]{testFixtures});
        });
        Configuration neoForgeModDevModules = (Configuration)project.getConfigurations().create("neoForgeTestModules", spec -> {
            spec.setDescription("Libraries that should be placed on the JVMs boot module path for unit tests.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith((Configuration)testRuntimeClasspathConfig.get());
            spec.withDependencies(set -> {
                set.addLater(extension.getVersion().map(version -> dependencyFactory.create((CharSequence)("net.neoforged:neoforge:" + version)).capabilities(caps -> caps.requireCapability((Object)"net.neoforged:neoforge-moddev-module-path")).exclude(Map.of("group", "org.jetbrains", "module", "annotations"))));
                set.add((Object)dependencyFactory.create((CharSequence)RunUtils.DEV_LAUNCH_GAV));
            });
        });
        Configuration legacyClasspathConfiguration = (Configuration)configurations.create("neoForgeTestLibraries", spec -> {
            spec.setDescription("Contains the legacy classpath of unit tests.");
            spec.setCanBeResolved(true);
            spec.setCanBeConsumed(false);
            spec.shouldResolveConsistentlyWith((Configuration)testRuntimeClasspathConfig.get());
            spec.attributes(attributes -> {
                attributes.attribute(ATTRIBUTE_DISTRIBUTION, (Object)"client");
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
            });
            spec.withDependencies(set -> set.addLater(neoForgeModDevLibrariesDependency));
        });
        Provider runArgsDir = modDevDir.map(dir -> dir.dir("junit"));
        TaskProvider writeLcpTask = tasks.register("writeNeoForgeTestClasspath", WriteLegacyClasspath.class, writeLcp -> {
            writeLcp.setGroup(INTERNAL_TASK_GROUP);
            writeLcp.setDescription("Writes the legacyClasspath file for the test run, containing all dependencies that shouldn't be considered boot modules.");
            writeLcp.getLegacyClasspathFile().convention(runArgsDir.map(dir -> dir.file("legacyClasspath.txt")));
            writeLcp.getEntries().from(new Object[]{legacyClasspathConfiguration});
            writeLcp.getEntries().from(new Object[]{((CreateMinecraftArtifactsTask)((Object)((Object)createArtifacts.get()))).getResourcesArtifact()});
        });
        Provider vmArgsFile = runArgsDir.map(dir -> dir.file("vmArgs.txt"));
        Provider programArgsFile = runArgsDir.map(dir -> dir.file("programArgs.txt"));
        Provider log4j2ConfigFile = runArgsDir.map(dir -> dir.file("log4j2.xml"));
        TaskProvider prepareTask = tasks.register("prepareNeoForgeTestFiles", PrepareTest.class, task -> {
            task.setGroup(INTERNAL_TASK_GROUP);
            task.setDescription("Prepares all files needed to run the JUnit test task.");
            task.getGameDirectory().set(gameDirectory);
            task.getVmArgsFile().set(vmArgsFile);
            task.getProgramArgsFile().set(programArgsFile);
            task.getLog4jConfigFile().set(log4j2ConfigFile);
            task.getNeoForgeModDevConfig().from(new Object[]{userDevConfigOnly});
            task.getModules().from(new Object[]{neoForgeModDevModules});
            task.getLegacyClasspathFile().set((Provider)((WriteLegacyClasspath)((Object)((Object)writeLcpTask.get()))).getLegacyClasspathFile());
            task.getAssetProperties().set(downloadAssets.flatMap(DownloadAssetsTask::getAssetPropertiesFile));
            task.getGameLogLevel().set((Object)Level.INFO);
        });
        ideSyncTask.configure(task -> task.dependsOn(new Object[]{prepareTask}));
        TaskProvider testTask = tasks.named("test", Test.class, task -> {
            task.dependsOn(new Object[]{prepareTask});
            task.systemProperty("fml.junit.argsfile", (Object)((RegularFile)programArgsFile.get()).getAsFile().getAbsolutePath());
            task.jvmArgs(new Object[]{RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)vmArgsFile.get()))});
            ModFoldersProvider modFoldersProvider = RunUtils.getGradleModFoldersProvider(project, (Provider<Set<ModModel>>)project.provider(extension::getMods), true);
            task.getJvmArgumentProviders().add(modFoldersProvider);
        });
        project.afterEvaluate(p -> {
            testTask.configure(task -> task.setWorkingDir(gameDirectory));
            Provider intellijVmArgsFile = runArgsDir.map(dir -> dir.file("intellijVmArgs.txt"));
            File outputDirectory = RunUtils.getIntellijOutputDirectory(project);
            String ideSpecificVmArgs = RunUtils.escapeJvmArg(RunUtils.getIdeaModFoldersProvider(project, outputDirectory, (Provider<Set<ModModel>>)unitTest.getTestedMod().map(Set::of), true).getArgument());
            try {
                Path vmArgsFilePath = ((RegularFile)intellijVmArgsFile.get()).getAsFile().toPath();
                Files.createDirectories(vmArgsFilePath.getParent(), new FileAttribute[0]);
                FileUtils.writeStringSafe(vmArgsFilePath, ideSpecificVmArgs);
            }
            catch (IOException e) {
                throw new GradleException("Failed to write VM args file for IntelliJ unit tests", (Throwable)e);
            }
            RunConfigurationContainer intelliJRunConfigurations = ModDevPlugin.getIntelliJRunConfigurations(p);
            if (intelliJRunConfigurations != null) {
                intelliJRunConfigurations.defaults(JUnit.class, jUnitDefaults -> {
                    jUnitDefaults.setWorkingDirectory("$MODULE_WORKING_DIR$/build/minecraft-junit");
                    jUnitDefaults.setVmParameters(RunUtils.escapeJvmArg("-Dfml.junit.argsfile=" + ModDevPlugin.buildRelativePath((Provider<RegularFile>)programArgsFile, gameDirectory)) + " " + RunUtils.escapeJvmArg("@" + ModDevPlugin.buildRelativePath((Provider<RegularFile>)vmArgsFile, gameDirectory)) + " " + RunUtils.escapeJvmArg("@" + ModDevPlugin.buildRelativePath((Provider<RegularFile>)intellijVmArgsFile, gameDirectory)));
                });
            }
        });
    }

    private static String buildRelativePath(Provider<RegularFile> file, File workingDirectory) {
        return workingDirectory.toPath().relativize(((RegularFile)file.get()).getAsFile().toPath()).toString().replace("\\", "/");
    }

    private static void setupJarJar(Project project) {
        SourceSetContainer sourceSets = ExtensionUtils.getExtension((ExtensionAware)project, "sourceSets", SourceSetContainer.class);
        sourceSets.configureEach(sourceSet -> {
            Configuration configuration = (Configuration)project.getConfigurations().create(sourceSet.getTaskName(null, "jarJar"));
            configuration.setTransitive(false);
            configuration.setCanBeResolved(true);
            configuration.setCanBeConsumed(false);
            JavaPluginExtension javaPlugin = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            configuration.attributes(attributes -> {
                attributes.attributeProvider(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, javaPlugin.getToolchain().getLanguageVersion().map(JavaLanguageVersion::asInt));
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "java-runtime")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)project.getObjects().named(LibraryElements.class, "jar")));
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external")));
            });
            TaskProvider jarJarTask = project.getTasks().register(sourceSet.getTaskName(null, "jarJar"), JarJar.class, jarJar -> {
                jarJar.setGroup(JAR_JAR_GROUP);
                jarJar.setDescription("Create a combined JAR of project and selected dependencies.");
                jarJar.configuration(configuration);
            });
            project.getTasks().withType(AbstractArchiveTask.class).named(name -> name.equals(sourceSet.getJarTaskName())).configureEach(task -> {
                task.from(new Object[]{((JarJar)((Object)((Object)((Object)jarJarTask.get())))).getOutputDirectory()});
                task.dependsOn(new Object[]{jarJarTask});
            });
        });
    }

    private static void addIntelliJRunConfiguration(Project project, RunConfigurationContainer runConfigurations, @Nullable File outputDirectory, RunModel run, PrepareRun prepareTask) {
        SourceSet sourceSet;
        Application appRun = new Application((String)run.getIdeName().get(), project);
        SourceSetContainer sourceSets = ExtensionUtils.getSourceSets(project);
        if (!sourceSets.contains((Object)(sourceSet = (SourceSet)run.getSourceSet().get()))) {
            throw new GradleException("Cannot use source set from another project for run " + run.getName());
        }
        appRun.setModuleRef(new ModuleRef(project, sourceSet));
        appRun.setWorkingDirectory(((Directory)run.getGameDirectory().get()).getAsFile().getAbsolutePath());
        appRun.setEnvs((Map)run.getEnvironment().get());
        appRun.setJvmArgs(RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getVmArgsFile().get())) + " " + RunUtils.escapeJvmArg(RunUtils.getIdeaModFoldersProvider(project, outputDirectory, run.getMods(), false).getArgument()));
        appRun.setMainClass(RunUtils.DEV_LAUNCH_MAIN_CLASS);
        appRun.setProgramParameters(RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getProgramArgsFile().get())));
        runConfigurations.add((Object)appRun);
    }

    private static void configureIntelliJModel(Project project, TaskProvider<Task> ideSyncTask, NeoForgeExtension extension, Map<RunModel, TaskProvider<PrepareRun>> prepareRunTasks) {
        Project rootProject = project.getRootProject();
        if (!rootProject.getPlugins().hasPlugin(IdeaExtPlugin.class)) {
            rootProject.getPlugins().apply(IdeaExtPlugin.class);
        }
        project.afterEvaluate(ignored -> {
            RunConfigurationContainer runConfigurations;
            ProjectSettings settings = ModDevPlugin.getIntelliJProjectSettings(rootProject);
            if (settings != null && IdeDetection.isIntelliJSync()) {
                StartParameter startParameter = project.getGradle().getStartParameter();
                ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
                taskRequests.add(new DefaultTaskExecutionRequest(List.of(ideSyncTask.getName())));
                startParameter.setTaskRequests(taskRequests);
            }
            if ((runConfigurations = ModDevPlugin.getIntelliJRunConfigurations(rootProject)) == null) {
                project.getLogger().debug("Failed to find IntelliJ run configuration container. Not adding run configurations.");
            } else {
                File outputDirectory = RunUtils.getIntellijOutputDirectory(project);
                for (RunModel run : extension.getRuns()) {
                    PrepareRun prepareTask = (PrepareRun)((Object)((Object)((TaskProvider)prepareRunTasks.get(run)).get()));
                    if (!prepareTask.getEnabled()) {
                        project.getLogger().lifecycle("Not creating IntelliJ run {} since its prepare task {} is disabled", new Object[]{run, prepareTask});
                        continue;
                    }
                    ModDevPlugin.addIntelliJRunConfiguration(project, runConfigurations, outputDirectory, run, prepareTask);
                }
            }
        });
    }

    @Nullable
    private static IdeaProject getIntelliJProject(Project project) {
        IdeaModel ideaModel = ExtensionUtils.findExtension((ExtensionAware)project, "idea", IdeaModel.class);
        if (ideaModel != null) {
            return ideaModel.getProject();
        }
        return null;
    }

    @Nullable
    private static ProjectSettings getIntelliJProjectSettings(Project project) {
        IdeaProject ideaProject = ModDevPlugin.getIntelliJProject(project);
        if (ideaProject != null) {
            return (ProjectSettings)((ExtensionAware)ideaProject).getExtensions().getByType(ProjectSettings.class);
        }
        return null;
    }

    @Nullable
    private static RunConfigurationContainer getIntelliJRunConfigurations(Project project) {
        ProjectSettings projectSettings = ModDevPlugin.getIntelliJProjectSettings(project);
        if (projectSettings != null) {
            return ExtensionUtils.findExtension((ExtensionAware)projectSettings, "runConfigurations", RunConfigurationContainer.class);
        }
        return null;
    }

    static String guessMavenGav(ResolvedArtifactResult result) {
        Object artifactId;
        String ext = "";
        String classifier = null;
        ComponentArtifactIdentifier componentArtifactIdentifier = result.getId();
        if (componentArtifactIdentifier instanceof ModuleComponentArtifactIdentifier) {
            ModuleComponentArtifactIdentifier moduleId = (ModuleComponentArtifactIdentifier)componentArtifactIdentifier;
            String artifact = moduleId.getComponentIdentifier().getModule();
            String version = moduleId.getComponentIdentifier().getVersion();
            String expectedBasename = artifact + "-" + version;
            String filename = result.getFile().getName();
            int startOfExt = filename.lastIndexOf(46);
            if (startOfExt != -1) {
                ext = filename.substring(startOfExt + 1);
                filename = filename.substring(0, startOfExt);
            }
            if (filename.startsWith(expectedBasename + "-")) {
                classifier = filename.substring((expectedBasename + "-").length());
            }
            artifactId = moduleId.getComponentIdentifier().getGroup() + ":" + artifact + ":" + version;
        } else {
            ext = "jar";
            artifactId = result.getId().getComponentIdentifier().toString();
        }
        Object gav = artifactId;
        if (classifier != null) {
            gav = (String)gav + ":" + classifier;
        }
        if (!"jar".equals(ext)) {
            gav = (String)gav + "@" + ext;
        }
        return gav;
    }

    private static void configureEclipseModel(Project project, TaskProvider<Task> ideSyncTask, TaskProvider<CreateMinecraftArtifactsTask> createArtifacts, NeoForgeExtension extension, Map<RunModel, TaskProvider<PrepareRun>> prepareRunTasks) {
        EclipseModel eclipseModel = ExtensionUtils.findExtension((ExtensionAware)project, "eclipse", EclipseModel.class);
        if (eclipseModel == null) {
            return;
        }
        eclipseModel.synchronizationTasks(new Object[]{ideSyncTask});
        if (!ModDevPlugin.shouldUseCombinedSourcesAndClassesArtifact()) {
            XmlFileContentMerger fileClasspath = eclipseModel.getClasspath().getFile();
            fileClasspath.whenMerged(classpath -> {
                File classesPath = ((RegularFile)((CreateMinecraftArtifactsTask)((Object)((Object)createArtifacts.get()))).getCompiledArtifact().get()).getAsFile();
                File sourcesPath = ((RegularFile)((CreateMinecraftArtifactsTask)((Object)((Object)createArtifacts.get()))).getSourcesArtifact().get()).getAsFile();
                for (ClasspathEntry entry : classpath.getEntries()) {
                    Library library;
                    if (!(entry instanceof Library) || !classesPath.equals(new File((library = (Library)entry).getPath()))) continue;
                    library.setSourcePath(classpath.fileReference((Object)sourcesPath));
                }
            });
        }
        if (IdeDetection.isEclipse()) {
            project.afterEvaluate(ignored -> {
                for (RunModel run : extension.getRuns()) {
                    PrepareRun prepareTask = (PrepareRun)((Object)((Object)((TaskProvider)prepareRunTasks.get(run)).get()));
                    if (!prepareTask.getEnabled()) {
                        project.getLogger().lifecycle("Not creating Eclipse run {} since its prepare task {} is disabled", new Object[]{run, prepareTask});
                        continue;
                    }
                    ModDevPlugin.addEclipseLaunchConfiguration(project, null, run, prepareTask);
                }
            });
        }
    }

    private static void addEclipseLaunchConfiguration(Project project, @Nullable File outputDirectory, RunModel run, PrepareRun prepareTask) {
        EclipseModel model = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
        JavaApplicationLaunchConfig config = JavaApplicationLaunchConfig.builder((String)model.getProject().getName()).vmArgs(new String[]{RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getVmArgsFile().get())), RunUtils.escapeJvmArg(RunUtils.getIdeaModFoldersProvider(project, outputDirectory, run.getMods(), false).getArgument())}).args(new String[]{RunUtils.escapeJvmArg(RunUtils.getArgFileParameter((RegularFile)prepareTask.getProgramArgsFile().get()))}).envVar((Map)run.getEnvironment().get()).workingDirectory(((Directory)run.getGameDirectory().get()).getAsFile().getAbsolutePath()).jreContainer("JavaSE-21").build(RunUtils.DEV_LAUNCH_MAIN_CLASS);
        String filename = (String)run.getIdeName().get();
        File file = project.file((Object)(".eclipse/configurations/" + filename + ".launch"));
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file, false);){
            config.write((Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write launch file: " + file, e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to write launch file: " + file, e);
        }
    }
}

