/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.PropertyUtils;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;

public abstract class NeoFormRuntime {
    private static final String DEFAULT_NFRT_VERSION = "0.1.52";

    @Inject
    public NeoFormRuntime(Project project) {
        this.getUseEclipseCompiler().convention(PropertyUtils.getBooleanProperty(project, "neoForge.neoFormRuntime.useEclipseCompiler").orElse((Object)false));
        this.getVersion().convention(PropertyUtils.getStringProperty(project, "neoForge.neoFormRuntime.version").orElse((Object)DEFAULT_NFRT_VERSION));
        this.getEnableCache().convention(PropertyUtils.getBooleanProperty(project, "neoForge.neoFormRuntime.enableCache").orElse((Object)true));
        this.getVerbose().convention(PropertyUtils.getBooleanProperty(project, "neoForge.neoFormRuntime.verbose").orElse((Object)false));
        this.getAnalyzeCacheMisses().convention(PropertyUtils.getBooleanProperty(project, "neoForge.neoFormRuntime.analyzeCacheMisses").orElse((Object)false));
    }

    public abstract Property<String> getVersion();

    public abstract Property<Boolean> getUseEclipseCompiler();

    public abstract Property<Boolean> getEnableCache();

    public abstract Property<Boolean> getVerbose();

    public abstract Property<Boolean> getAnalyzeCacheMisses();
}

