/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.jarjar.metadata.Metadata;
import net.neoforged.jarjar.metadata.MetadataIOHandler;
import net.neoforged.moddevgradle.internal.jarjar.JarJarArtifacts;
import net.neoforged.moddevgradle.internal.jarjar.ResolvedJarJarArtifact;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.ApiStatus;

public abstract class JarJar
extends DefaultTask {
    private final FileSystemOperations fileSystemOperations;

    @Nested
    @ApiStatus.Internal
    protected abstract JarJarArtifacts getJarJarArtifacts();

    @InputFiles
    @SkipWhenEmpty
    @ApiStatus.Internal
    protected abstract ConfigurableFileCollection getInputFiles();

    @Inject
    @ApiStatus.Internal
    protected abstract ObjectFactory getObjects();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Inject
    public JarJar(FileSystemOperations fileSystemOperations) {
        this.fileSystemOperations = fileSystemOperations;
        this.getOutputDirectory().convention(this.getProject().getLayout().getBuildDirectory().dir("generated/" + this.getName()));
    }

    @TaskAction
    protected void run() {
        List includedJars = (List)this.getJarJarArtifacts().getResolvedArtifacts().get();
        this.fileSystemOperations.delete(spec -> spec.delete(new Object[]{this.getOutputDirectory()}));
        if (!includedJars.isEmpty()) {
            this.fileSystemOperations.copy(spec -> {
                spec.into((Object)this.getOutputDirectory().dir("META-INF/jarjar"));
                spec.from(includedJars.stream().map(ResolvedJarJarArtifact::getFile).toArray());
                spec.from(new Object[]{this.writeMetadata(includedJars).toFile()});
            });
        }
    }

    private Path writeMetadata(List<ResolvedJarJarArtifact> includedJars) {
        Path metadataPath = this.getJarJarMetadataPath();
        Metadata metadata = this.createMetadata(includedJars);
        try {
            metadataPath.toFile().getParentFile().mkdirs();
            Files.deleteIfExists(metadataPath);
            Files.write(metadataPath, (Iterable<? extends CharSequence>)MetadataIOHandler.toLines((Metadata)metadata), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write JarJar dependency metadata to disk.", e);
        }
        return metadataPath;
    }

    public void configuration(Configuration jarJarConfiguration) {
        this.getInputFiles().from(new Object[]{jarJarConfiguration});
        this.getJarJarArtifacts().configuration(jarJarConfiguration);
        this.dependsOn(new Object[]{jarJarConfiguration});
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        ConfigurableFileCollection newConfig = this.getObjects().fileCollection();
        newConfig.from(configurations.toArray());
        this.getInputFiles().setFrom((Iterable)newConfig);
        this.getJarJarArtifacts().setConfigurations(configurations);
        configurations.forEach(xva$0 -> this.dependsOn(new Object[]{xva$0}));
    }

    private Path getJarJarMetadataPath() {
        return this.getTemporaryDir().toPath().resolve("metadata.json");
    }

    private Metadata createMetadata(List<ResolvedJarJarArtifact> jars) {
        return new Metadata(jars.stream().map(ResolvedJarJarArtifact::createContainerMetadata).collect(Collectors.toList()));
    }
}

