/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.neoforged.moddevgradle.dsl.InternalModelHelper;
import net.neoforged.moddevgradle.dsl.ModModel;
import net.neoforged.moddevgradle.dsl.NeoForgeExtension;
import net.neoforged.moddevgradle.dsl.RunModel;
import net.neoforged.moddevgradle.internal.AssetProperties;
import net.neoforged.moddevgradle.internal.ModFolder;
import net.neoforged.moddevgradle.internal.ModFoldersProvider;
import net.neoforged.moddevgradle.internal.utils.ExtensionUtils;
import net.neoforged.moddevgradle.internal.utils.IdeDetection;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;
import org.xml.sax.InputSource;

final class RunUtils {
    public static String DEV_LAUNCH_GAV = "net.neoforged:DevLaunch:1.0.0";
    public static String DEV_LAUNCH_MAIN_CLASS = "net.neoforged.devlaunch.Main";
    @Language(value="xpath")
    public static final String IDEA_DELEGATED_BUILD_XPATH = "/project/component[@name='GradleSettings']/option[@name='linkedExternalProjectsSettings']/GradleProjectSettings/option[@name='delegatedBuild']/@value";
    @Language(value="xpath")
    public static final String IDEA_OUTPUT_XPATH = "/project/component[@name='ProjectRootManager']/output/@url";

    private RunUtils() {
    }

    public static String escapeJvmArg(String arg) {
        String escaped = arg.replace("\\", "\\\\").replace("\"", "\\\"");
        if (escaped.contains(" ")) {
            return "\"" + escaped + "\"";
        }
        return escaped;
    }

    public static Provider<String> getRequiredType(Project project, RunModel runModel) {
        return runModel.getType().orElse(project.getProviders().provider(() -> {
            throw new GradleException("The run '" + runModel.getName() + "' did not specify a type property");
        }));
    }

    public static AssetProperties loadAssetProperties(File file) {
        Properties assetProperties = new Properties();
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            assetProperties.load(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load asset properties", e);
        }
        if (!assetProperties.containsKey("assets_root")) {
            throw new IllegalStateException("Asset properties file does not contain assets_root");
        }
        if (!assetProperties.containsKey("asset_index")) {
            throw new IllegalStateException("Asset properties file does not contain asset_index");
        }
        return new AssetProperties(assetProperties.getProperty("asset_index"), assetProperties.getProperty("assets_root"));
    }

    public static void writeLog4j2Configuration(Level rootLevel, Path destination) throws IOException {
        Files.writeString(destination, (CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Configuration status=\"warn\" shutdownHook=\"disable\">\n    <filters>\n        <ThresholdFilter level=\"WARN\" onMatch=\"ACCEPT\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"NETWORK_PACKETS\" onMatch=\"${sys:forge.logging.marker.networking:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"CLASSLOADING\" onMatch=\"${sys:forge.logging.marker.classloading:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"LAUNCHPLUGIN\" onMatch=\"${sys:forge.logging.marker.launchplugin:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"CLASSDUMP\" onMatch=\"${sys:forge.logging.marker.classdump:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"AXFORM\" onMatch=\"${sys:forge.logging.marker.axform:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"EVENTBUS\" onMatch=\"${sys:forge.logging.marker.eventbus:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"DISTXFORM\" onMatch=\"${sys:forge.logging.marker.distxform:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"SCAN\" onMatch=\"${sys:forge.logging.marker.scan:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"REGISTRIES\" onMatch=\"${sys:forge.logging.marker.registries:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"REGISTRYDUMP\" onMatch=\"${sys:forge.logging.marker.registrydump:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"SPLASH\" onMatch=\"${sys:forge.logging.marker.splash:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"RESOURCE-CACHE\" onMatch=\"${sys:forge.logging.marker.resource.cache:-DENY}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"FORGEMOD\" onMatch=\"${sys:forge.logging.marker.forgemod:-NEUTRAL}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"LOADING\" onMatch=\"${sys:forge.logging.marker.loading:-NEUTRAL}\" onMismatch=\"NEUTRAL\"/>\n        <MarkerFilter marker=\"CORE\" onMatch=\"${sys:forge.logging.marker.core:-NEUTRAL}\" onMismatch=\"NEUTRAL\"/>\n    </filters>\n    <Appenders>\n        <Console name=\"Console\">\n            <PatternLayout>\n                <LoggerNamePatternSelector defaultPattern=\"%highlightForge{[%d{HH:mm:ss}] [%t/%level] [%c{2.}/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}%n%tEx}\">\n                    <!-- don't include the full logger name for Mojang's logs since they use full class names and it's very verbose -->\n                    <PatternMatch key=\"net.minecraft.\" pattern=\"%highlightForge{[%d{HH:mm:ss}] [%t/%level] [minecraft/%logger{1}]: %minecraftFormatting{%msg{nolookup}}%n%tEx}\"/>\n                    <PatternMatch key=\"com.mojang.\" pattern=\"%highlightForge{[%d{HH:mm:ss}] [%t/%level] [mojang/%logger{1}]: %minecraftFormatting{%msg{nolookup}}%n%tEx}\"/>\n                </LoggerNamePatternSelector>\n            </PatternLayout>\n        </Console>\n        <Queue name=\"ServerGuiConsole\" ignoreExceptions=\"true\">\n            <PatternLayout>\n                <LoggerNamePatternSelector defaultPattern=\"[%d{HH:mm:ss}] [%t/%level] [%c{2.}/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}{strip}%n\">\n                    <!-- don't include the full logger name for Mojang's logs since they use full class names and it's very verbose -->\n                    <PatternMatch key=\"net.minecraft.\" pattern=\"[%d{HH:mm:ss}] [%t/%level] [minecraft/%logger{1}]: %minecraftFormatting{%msg{nolookup}}{strip}%n\"/>\n                    <PatternMatch key=\"com.mojang.\" pattern=\"[%d{HH:mm:ss}] [%t/%level] [mojang/%logger{1}]: %minecraftFormatting{%msg{nolookup}}{strip}%n\"/>\n                </LoggerNamePatternSelector>\n            </PatternLayout>\n        </Queue>\n        <RollingRandomAccessFile name=\"File\" fileName=\"logs/latest.log\" filePattern=\"logs/%d{yyyy-MM-dd}-%i.log.gz\">\n            <PatternLayout pattern=\"[%d{ddMMMyyyy HH:mm:ss.SSS}] [%t/%level] [%logger/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}{strip}%n%xEx\"/>\n            <Policies>\n                <TimeBasedTriggeringPolicy/>\n                <OnStartupTriggeringPolicy/>\n            </Policies>\n            <DefaultRolloverStrategy max=\"99\" fileIndex=\"min\"/>\n        </RollingRandomAccessFile>\n        <RollingRandomAccessFile name=\"DebugFile\" fileName=\"logs/debug.log\" filePattern=\"logs/debug-%i.log.gz\">\n            <PatternLayout pattern=\"[%d{ddMMMyyyy HH:mm:ss.SSS}] [%t/%level] [%logger/%markerSimpleName]: %minecraftFormatting{%msg{nolookup}}{strip}%n%xEx\"/>\n            <Policies>\n                <OnStartupTriggeringPolicy/>\n                <SizeBasedTriggeringPolicy size=\"200MB\"/>\n            </Policies>\n            <DefaultRolloverStrategy max=\"5\" fileIndex=\"min\"/>\n        </RollingRandomAccessFile>\n    </Appenders>\n    <Loggers>\n        <!-- make sure mojang's logging is set to 'info' so that their LOGGER.isDebugEnabled() behavior isn't active -->\n        <Logger level=\"${sys:forge.logging.mojang.level:-info}\" name=\"com.mojang\"/>\n        <Logger level=\"${sys:forge.logging.mojang.level:-info}\" name=\"net.minecraft\"/>\n        <Logger level=\"${sys:forge.logging.classtransformer.level:-info}\" name=\"cpw.mods.modlauncher.ClassTransformer\"/>\n\n        <!-- Netty reflects into JDK internals, and it's causing useless DEBUG-level error stacktraces. We just ignore them -->\n        <Logger name=\"io.netty.util.internal.PlatformDependent0\">\n            <filters>\n                <RegexFilter regex=\"^direct buffer constructor: unavailable$\" onMatch=\"DENY\" onMismatch=\"NEUTRAL\" />\n                <RegexFilter regex=\"^jdk\\.internal\\.misc\\.Unsafe\\.allocateUninitializedArray\\(int\\): unavailable$\" onMatch=\"DENY\" onMismatch=\"NEUTRAL\" />\n            </filters>\n        </Logger>\n\n        <Root level=\"$ROOTLEVEL$\">\n            <AppenderRef ref=\"Console\" />\n            <AppenderRef ref=\"ServerGuiConsole\" level=\"${sys:forge.logging.console.level:-info}\"/>\n            <AppenderRef ref=\"File\" level=\"${sys:forge.logging.file.level:-info}\"/>\n            <AppenderRef ref=\"DebugFile\" />\n        </Root>\n    </Loggers>\n</Configuration>\n".replace("$ROOTLEVEL$", rootLevel.name()), new OpenOption[0]);
    }

    public static File getArgFile(Provider<Directory> modDevFolder, RunModel run, RunArgFile type) {
        return ((Directory)modDevFolder.get()).file(InternalModelHelper.nameOfRun(run, "", type.filename)).getAsFile();
    }

    public static String getArgFileParameter(RegularFile argFile) {
        return "@" + argFile.getAsFile().getAbsolutePath();
    }

    public static ModFoldersProvider getGradleModFoldersProvider(Project project, Provider<Set<ModModel>> modsProvider, boolean includeUnitTests) {
        ModFoldersProvider modFoldersProvider = (ModFoldersProvider)project.getObjects().newInstance(ModFoldersProvider.class, new Object[0]);
        modFoldersProvider.getModFolders().set(RunUtils.getModFoldersForGradle(project, modsProvider, includeUnitTests));
        return modFoldersProvider;
    }

    public static ModFoldersProvider getIdeaModFoldersProvider(Project project, @Nullable File outputDirectory, Provider<Set<ModModel>> modsProvider, boolean includeUnitTests) {
        Provider<Map<String, ModFolder>> folders = outputDirectory != null ? RunUtils.buildModFolders(project, modsProvider, includeUnitTests, (sourceSet, output) -> {
            Path sourceSetDir = outputDirectory.toPath().resolve(RunUtils.getIdeaOutName(sourceSet));
            output.from(new Object[]{sourceSetDir.resolve("classes"), sourceSetDir.resolve("resources")});
        }) : RunUtils.getModFoldersForGradle(project, modsProvider, includeUnitTests);
        ModFoldersProvider modFoldersProvider = (ModFoldersProvider)project.getObjects().newInstance(ModFoldersProvider.class, new Object[0]);
        modFoldersProvider.getModFolders().set(folders);
        return modFoldersProvider;
    }

    private static String getIdeaOutName(SourceSet sourceSet) {
        return sourceSet.getName().equals("main") ? "production" : sourceSet.getName();
    }

    private static Provider<Map<String, ModFolder>> getModFoldersForGradle(Project project, Provider<Set<ModModel>> modsProvider, boolean includeUnitTests) {
        return RunUtils.buildModFolders(project, modsProvider, includeUnitTests, (sourceSet, output) -> output.from(new Object[]{sourceSet.getOutput()}));
    }

    private static Provider<Map<String, ModFolder>> buildModFolders(Project project, Provider<Set<ModModel>> modsProvider, boolean includeUnitTests, BiConsumer<SourceSet, ConfigurableFileCollection> outputFolderResolver) {
        NeoForgeExtension extension = ExtensionUtils.findExtension((ExtensionAware)project, "neoForge", NeoForgeExtension.class);
        Provider testedModProvider = extension.getUnitTest().getTestedMod().filter(m -> includeUnitTests).map(Optional::of).orElse(Optional.empty());
        return modsProvider.zip(testedModProvider, (mods, testedMod) -> mods.stream().collect(Collectors.toMap(ModModel::getName, mod -> {
            SourceSet testSourceSet;
            ModFolder modFolder = (ModFolder)project.getObjects().newInstance(ModFolder.class, new Object[0]);
            modFolder.getFolders().from(new Object[]{InternalModelHelper.getModConfiguration(mod)});
            List sourceSets = (List)mod.getModSourceSets().get();
            for (SourceSet sourceSet : sourceSets) {
                outputFolderResolver.accept(sourceSet, modFolder.getFolders());
            }
            if (testedMod.isPresent() && testedMod.get() == mod && (testSourceSet = (SourceSet)ExtensionUtils.getSourceSets(project).findByName("test")) != null && !sourceSets.contains(testSourceSet)) {
                outputFolderResolver.accept(testSourceSet, modFolder.getFolders());
            }
            return modFolder;
        })));
    }

    @Nullable
    static File getIntellijOutputDirectory(Project project) {
        File ideaDir = IdeDetection.getIntellijProjectDir(project);
        if (ideaDir == null) {
            return null;
        }
        File gradleXml = new File(ideaDir, "gradle.xml");
        String delegatedBuild = RunUtils.evaluateXPath(gradleXml, IDEA_DELEGATED_BUILD_XPATH);
        if (!"false".equals(delegatedBuild)) {
            return null;
        }
        File miscXml = new File(ideaDir, "misc.xml");
        String outputDirUrl = RunUtils.evaluateXPath(miscXml, IDEA_OUTPUT_XPATH);
        if (outputDirUrl == null) {
            outputDirUrl = "file://$PROJECT_DIR$/out";
        }
        outputDirUrl = outputDirUrl.replace("$PROJECT_DIR$", project.getProjectDir().getAbsolutePath());
        outputDirUrl = outputDirUrl.replaceAll("^file:", "");
        return new File(outputDirUrl);
    }

    @Nullable
    private static String evaluateXPath(File file, @Language(value="xpath") String expression) {
        String string;
        FileInputStream fis = new FileInputStream(file);
        try {
            String result = XPathFactory.newInstance().newXPath().evaluate(expression, new InputSource(fis));
            string = result.isBlank() ? null : result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | XPathExpressionException ignored) {
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to evaluate xpath " + expression + " on file " + file, e);
            }
        }
        fis.close();
        return string;
    }

    public static enum RunArgFile {
        VMARGS("runVmArgs.txt"),
        PROGRAMARGS("runProgramArgs.txt"),
        LOG4J_CONFIG("log4j2.xml");

        private final String filename;

        private RunArgFile(String filename) {
            this.filename = filename;
        }
    }
}

