/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.PropertyUtils;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class Parchment {
    @Inject
    public Parchment(Project project) {
        this.getParchmentArtifact().convention(project.getProviders().gradleProperty("neoForge.parchment.parchmentArtifact").orElse(this.getMinecraftVersion().zip(this.getMappingsVersion(), (minecraftVersion, mappingVersion) -> "org.parchmentmc.data:parchment-" + minecraftVersion + ":" + mappingVersion + ":checked@zip")));
        this.getMinecraftVersion().convention(project.getProviders().gradleProperty("neoForge.parchment.minecraftVersion"));
        this.getMappingsVersion().convention(project.getProviders().gradleProperty("neoForge.parchment.mappingsVersion"));
        this.getEnabled().convention(this.getParchmentArtifact().map(s -> !s.isEmpty()).orElse(PropertyUtils.getBooleanProperty(project, "neoForge.parchment.enabled").orElse((Object)false)));
    }

    @Input
    @Optional
    public abstract Property<String> getParchmentArtifact();

    @Input
    @Optional
    public abstract Property<String> getMinecraftVersion();

    @Input
    @Optional
    public abstract Property<String> getMappingsVersion();

    @Input
    public abstract Property<Boolean> getEnabled();
}

