/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.dsl;

import java.util.List;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.utils.StringUtils;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public abstract class ModModel
implements Named {
    private Configuration configuration;

    @Inject
    public ModModel() {
        this.getModSourceSets().convention(List.of());
        this.getModSourceSets().finalizeValueOnRead();
    }

    @Inject
    protected abstract Project getProject();

    public abstract String getName();

    Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = (Configuration)this.getProject().getConfigurations().create("neoForgeModContent" + StringUtils.capitalize(this.getName()), configuration -> {
                configuration.setCanBeConsumed(false);
                configuration.setCanBeResolved(true);
            });
        }
        return this.configuration;
    }

    public abstract ListProperty<SourceSet> getModSourceSets();

    public void sourceSet(SourceSet sourceSet) {
        this.sourceSet(sourceSet, this.getProject());
    }

    public void dependency(CharSequence dependencyNotation) {
        this.getConfiguration().getDependencies().add((Object)this.getProject().getDependencyFactory().create(dependencyNotation));
    }

    public void dependency(Project projectRef) {
        this.getConfiguration().getDependencies().add((Object)this.getProject().getDependencyFactory().create(projectRef));
    }

    public void extendsFrom(Configuration configuration) {
        this.getConfiguration().extendsFrom(new Configuration[]{configuration});
    }

    public void sourceSet(SourceSet sourceSet, Project project) {
        if (!((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).contains((Object)sourceSet)) {
            throw new IllegalArgumentException("Source set " + sourceSet + " does not belong to project " + project);
        }
        this.getModSourceSets().add((Object)sourceSet);
    }
}

