/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import net.neoforged.moddev.shadow.com.google.gson.Gson;
import net.neoforged.moddev.shadow.com.google.gson.GsonBuilder;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.ContainedJarIdentifier;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.ContainedJarMetadata;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.ContainedVersion;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.Metadata;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json.ArtifactVersionSerializer;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json.ContainedJarIdentifierSerializer;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json.ContainedJarMetadataSerializer;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json.ContainedVersionSerializer;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json.MetadataSerializer;
import net.neoforged.moddev.shadow.net.neoforged.jarjar.metadata.json.VersionRangeSerializer;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.ArtifactVersion;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import net.neoforged.moddev.shadow.org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataIOHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataIOHandler.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)VersionRange.class), new VersionRangeSerializer()).registerTypeAdapter((Type)((Object)ArtifactVersion.class), new ArtifactVersionSerializer()).registerTypeAdapter((Type)((Object)DefaultArtifactVersion.class), new ArtifactVersionSerializer()).registerTypeAdapter((Type)((Object)ContainedJarIdentifier.class), new ContainedJarIdentifierSerializer()).registerTypeAdapter((Type)((Object)ContainedJarMetadata.class), new ContainedJarMetadataSerializer()).registerTypeAdapter((Type)((Object)ContainedVersion.class), new ContainedVersionSerializer()).registerTypeAdapter((Type)((Object)Metadata.class), new MetadataSerializer()).setPrettyPrinting().create();

    private MetadataIOHandler() {
        throw new IllegalStateException("Can not instantiate an instance of: MetadataIOHandler. This is a utility class");
    }

    public static Optional<Metadata> fromStream(InputStream stream) {
        try {
            return Optional.of(GSON.fromJson((Reader)new InputStreamReader(stream), Metadata.class));
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse metadata", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Iterable<String> toLines(Metadata metadata) {
        return Arrays.asList(GSON.toJson(metadata).split("\n"));
    }

    public static InputStream toInputStream(Metadata metadata) {
        String values = GSON.toJson(metadata);
        return new ByteArrayInputStream(values.getBytes());
    }
}

