/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.moddevgradle.internal.NeoFormRuntimeEngineTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Implements its own caching")
abstract class CreateMinecraftArtifactsTask
extends NeoFormRuntimeEngineTask {
    @Inject
    public CreateMinecraftArtifactsTask() {
    }

    @InputFiles
    abstract ConfigurableFileCollection getAccessTransformers();

    @Input
    @Optional
    abstract Property<Boolean> getValidateAccessTransformers();

    @Input
    abstract Property<Boolean> getParchmentEnabled();

    @InputFiles
    abstract ConfigurableFileCollection getParchmentData();

    @Input
    abstract Property<String> getParchmentConflictResolutionPrefix();

    @OutputFile
    abstract RegularFileProperty getCompiledWithSourcesArtifact();

    @OutputFile
    abstract RegularFileProperty getCompiledArtifact();

    @OutputFile
    abstract RegularFileProperty getSourcesArtifact();

    @OutputFile
    abstract RegularFileProperty getResourcesArtifact();

    @TaskAction
    public void createArtifacts() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("run");
        Set accessTransformers = this.getAccessTransformers().getFiles();
        for (File accessTransformer : accessTransformers) {
            args.add("--access-transformer");
            args.add(accessTransformer.getAbsolutePath());
        }
        if (((Boolean)this.getValidateAccessTransformers().getOrElse((Object)false)).booleanValue()) {
            args.add("--validate-access-transformers");
        }
        if (((Boolean)this.getParchmentEnabled().get()).booleanValue()) {
            Set parchmentData = this.getParchmentData().getFiles();
            if (parchmentData.size() == 1) {
                args.add("--parchment-data");
                args.add(((File)parchmentData.iterator().next()).getAbsolutePath());
            } else if (parchmentData.size() > 1) {
                throw new GradleException("More than one parchment data file was specified: " + parchmentData);
            }
            String conflictResolutionPrefix = (String)this.getParchmentConflictResolutionPrefix().getOrElse((Object)"");
            if (this.getParchmentConflictResolutionPrefix().isPresent() && !conflictResolutionPrefix.isBlank()) {
                args.add("--parchment-conflict-prefix");
                args.add(conflictResolutionPrefix);
            }
        }
        Collections.addAll(args, "--dist", "joined", "--write-result", "clientResources:" + ((RegularFile)this.getResourcesArtifact().get()).getAsFile().getAbsolutePath());
        if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--write-result", "compiledWithNeoForge:" + ((RegularFile)this.getCompiledArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sourcesWithNeoForge:" + ((RegularFile)this.getSourcesArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sourcesAndCompiledWithNeoForge:" + ((RegularFile)this.getCompiledWithSourcesArtifact().get()).getAsFile().getAbsolutePath());
        } else {
            Collections.addAll(args, "--write-result", "compiled:" + ((RegularFile)this.getCompiledArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sources:" + ((RegularFile)this.getSourcesArtifact().get()).getAsFile().getAbsolutePath(), "--write-result", "sourcesAndCompiled:" + ((RegularFile)this.getCompiledWithSourcesArtifact().get()).getAsFile().getAbsolutePath());
        }
        this.run(args);
    }
}

