/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import org.gradle.api.GradleException;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;

public abstract class OperatingSystemDisambiguation
implements AttributeDisambiguationRule<String> {
    public void execute(MultipleCandidatesDetails<String> details) {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
            osName = "linux";
        } else if (osName.startsWith("Mac OS X")) {
            osName = "osx";
        } else if (osName.startsWith("Windows")) {
            osName = "windows";
        } else {
            throw new GradleException("Unsupported operating system: " + osName);
        }
        details.closestMatch((Object)osName);
    }
}

