/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.moddevgradle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.neoforged.moddevgradle.internal.NeoFormRuntimeTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class NeoFormRuntimeEngineTask
extends NeoFormRuntimeTask {
    public NeoFormRuntimeEngineTask() {
        this.getOutputs().upToDateWhen(task -> (Boolean)((NeoFormRuntimeEngineTask)((Object)task)).getEnableCache().get());
        this.getEnableCache().convention((Object)false);
        this.getUseEclipseCompiler().convention((Object)false);
        this.getAnalyzeCacheMisses().convention((Object)false);
        this.getVerbose().convention((Object)false);
    }

    @Input
    @Optional
    abstract Property<String> getNeoForgeArtifact();

    @Input
    @Optional
    abstract Property<String> getNeoFormArtifact();

    @Internal
    abstract Property<Boolean> getVerbose();

    @InputFile
    @Optional
    abstract RegularFileProperty getArtifactManifestFile();

    @Internal
    abstract Property<Boolean> getEnableCache();

    @Internal
    abstract Property<Boolean> getAnalyzeCacheMisses();

    @Input
    abstract Property<Boolean> getUseEclipseCompiler();

    @Override
    protected void run(List<String> args) {
        args = new ArrayList<String>(args);
        if (((Boolean)this.getVerbose().get()).booleanValue()) {
            args.add("--verbose");
        }
        if (this.getArtifactManifestFile().isPresent()) {
            args.add("--artifact-manifest");
            args.add(((RegularFile)this.getArtifactManifestFile().get()).getAsFile().getAbsolutePath());
            args.add("--warn-on-artifact-manifest-miss");
        }
        if (!((Boolean)this.getEnableCache().get()).booleanValue()) {
            args.add("--disable-cache");
        }
        if (((Boolean)this.getAnalyzeCacheMisses().get()).booleanValue()) {
            args.add("--analyze-cache-misses");
        }
        if (((Boolean)this.getUseEclipseCompiler().get()).booleanValue()) {
            args.add("--use-eclipse-compiler");
        }
        if (this.getNeoForgeArtifact().isPresent()) {
            Collections.addAll(args, "--neoforge", (String)this.getNeoForgeArtifact().get() + ":userdev");
        }
        if (this.getNeoFormArtifact().isPresent()) {
            Collections.addAll(args, "--neoform", (String)this.getNeoFormArtifact().get());
        }
        if (!this.getNeoFormArtifact().isPresent() && !this.getNeoForgeArtifact().isPresent()) {
            throw new GradleException("You need to specify at least 'version' or 'neoFormVersion' in the 'neoForge' block of your build script.");
        }
        super.run(args);
    }
}

