/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.mergetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.mergetool.AnnotationVersion;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class Stripper {
    private Set<String> classes = new HashSet<String>();
    private Set<String> targets = new HashSet<String>();

    public void loadData(File file) throws IOException {
        Files.lines(file.toPath()).forEach(line -> {
            int idx = line.indexOf(35);
            if (idx == 0 || line.isEmpty()) {
                return;
            }
            if (idx != -1) {
                line = line.substring(0, idx - 1);
            }
            if (line.charAt(0) == '\t') {
                line = line.substring(1);
            }
            String[] pts = (line.trim() + "    ").split(" ", -1);
            this.classes.add(pts[0]);
            if (pts.length > 1) {
                this.targets.add(pts[0] + ' ' + pts[1]);
            } else {
                this.targets.add(pts[0]);
            }
        });
    }

    public void process(File input, File output) throws IOException {
        if (output.exists()) {
            output.delete();
        }
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        output.createNewFile();
        HashSet<String> types = new HashSet<String>();
        for (AnnotationVersion an : AnnotationVersion.values()) {
            for (String cls : an.getClasses()) {
                types.add('L' + cls + ';');
            }
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(input));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(output));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                ZipEntry next = new ZipEntry(entry.getName());
                next.setTime(entry.getTime());
                next.setLastModifiedTime(entry.getLastModifiedTime());
                zos.putNextEntry(next);
                if (!entry.getName().endsWith(".class") || !this.classes.contains(entry.getName().substring(0, entry.getName().length() - 6))) {
                    int read;
                    byte[] buf = new byte[256];
                    while ((read = zis.read(buf, 0, buf.length)) != -1) {
                        zos.write(buf, 0, read);
                    }
                } else {
                    ClassReader reader = new ClassReader((InputStream)zis);
                    ClassNode node = new ClassNode();
                    reader.accept((ClassVisitor)node, 0);
                    if (node.methods != null) {
                        node.methods.forEach(mtd -> {
                            if (this.targets.contains(node.name + ' ' + mtd.name + mtd.desc) && mtd.visibleAnnotations != null) {
                                Iterator itr = mtd.visibleAnnotations.iterator();
                                while (itr.hasNext()) {
                                    if (!types.contains(((AnnotationNode)itr.next()).desc)) continue;
                                    itr.remove();
                                }
                            }
                        });
                    }
                    if (node.visibleAnnotations != null) {
                        Iterator itr = node.visibleAnnotations.iterator();
                        while (itr.hasNext()) {
                            if (!types.contains(((AnnotationNode)itr.next()).desc)) continue;
                            itr.remove();
                        }
                    }
                    ClassWriter writer = new ClassWriter(1);
                    node.accept((ClassVisitor)writer);
                    zos.write(writer.toByteArray());
                }
                zos.closeEntry();
            }
        }
    }
}

