/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.mergetool;

import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.api.distmarker.OnlyIns;
import net.neoforged.fml.relauncher.Side;
import net.neoforged.srgutils.MinecraftVersion;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public enum AnnotationVersion {
    CPW(SideOnly.class, cpw.mods.fml.relauncher.Side.class, "CLIENT", "SERVER"),
    NMF(net.neoforged.fml.relauncher.SideOnly.class, Side.class, "CLIENT", "SERVER"),
    API(OnlyIn.class, Dist.class, OnlyIns.class, "_interface", "CLIENT", "DEDICATED_SERVER");

    private final String holder;
    private final String value;
    private final String repeatable;
    private final String interface_key;
    private final String client;
    private final String server;
    private static final MinecraftVersion MC_8;
    private static final MinecraftVersion MC_13;

    private AnnotationVersion(Class<?> holder, Class<?> value, String client, String server) {
        this(holder, value, null, null, client, server);
    }

    private AnnotationVersion(Class<?> holder, Class<?> value, Class<?> repeatable, String interface_key, String client, String server) {
        this.holder = Type.getDescriptor(holder);
        this.value = Type.getDescriptor(value);
        this.repeatable = repeatable == null ? null : Type.getDescriptor(repeatable);
        this.interface_key = interface_key;
        this.client = client;
        this.server = server;
    }

    public static AnnotationVersion fromVersion(String v) {
        if (v == null) {
            return NMF;
        }
        try {
            MinecraftVersion target = MinecraftVersion.from((String)v);
            if (target.compareTo(MC_8) < 0) {
                return CPW;
            }
            if (target.compareTo(MC_13) < 0) {
                return NMF;
            }
            return API;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String[] getClasses() {
        if (this.repeatable == null) {
            return new String[]{Type.getType((String)this.holder).getInternalName(), Type.getType((String)this.value).getInternalName()};
        }
        return new String[]{Type.getType((String)this.holder).getInternalName(), Type.getType((String)this.value).getInternalName(), Type.getType((String)this.repeatable).getInternalName()};
    }

    public void add(ClassVisitor cls, List<String> clientOnly, List<String> serverOnly) {
        if (this.repeatable == null || this.interface_key == null) {
            return;
        }
        if (clientOnly.size() + serverOnly.size() == 1) {
            if (clientOnly.size() == 1) {
                this.add(cls.visitAnnotation(this.holder, true), true).visit(this.interface_key, (Object)Type.getObjectType((String)clientOnly.get(0)));
            } else {
                this.add(cls.visitAnnotation(this.holder, true), false).visit(this.interface_key, (Object)Type.getObjectType((String)serverOnly.get(0)));
            }
        } else {
            AnnotationVisitor rep = cls.visitAnnotation(this.holder, true).visitArray("value");
            clientOnly.forEach(intf -> this.add(rep.visitAnnotation(null, this.repeatable), true).visit(this.interface_key, (Object)Type.getObjectType((String)intf)));
            serverOnly.forEach(intf -> this.add(rep.visitAnnotation(null, this.repeatable), false).visit(this.interface_key, (Object)Type.getObjectType((String)intf)));
        }
    }

    public void add(ClassVisitor cls, boolean isClientOnly) {
        this.add(cls.visitAnnotation(this.holder, true), isClientOnly);
    }

    public void add(FieldVisitor fld, boolean isClientOnly) {
        this.add(fld.visitAnnotation(this.holder, true), isClientOnly);
    }

    public void add(MethodVisitor mtd, boolean isClientOnly) {
        this.add(mtd.visitAnnotation(this.holder, true), isClientOnly);
    }

    private AnnotationVisitor add(AnnotationVisitor ann, boolean isClientOnly) {
        ann.visitEnum("value", this.value, isClientOnly ? this.client : this.server);
        return ann;
    }

    static {
        MC_8 = MinecraftVersion.from((String)"14w02a");
        MC_13 = MinecraftVersion.from((String)"17w43a");
    }
}

