/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class PostProcessors {
    private final InstallV1 profile;
    private final boolean isClient;
    private final ProgressCallback monitor;
    private final boolean hasTasks;
    private final Map<String, String> data;
    private final List<Install.Processor> processors;
    private static boolean clChecked = false;
    private static ClassLoader parentClassLoader = null;

    public PostProcessors(InstallV1 profile, boolean isClient, ProgressCallback monitor) {
        this.profile = profile;
        this.isClient = isClient;
        this.monitor = monitor;
        this.processors = profile.getProcessors(isClient ? "client" : "server");
        this.hasTasks = !this.processors.isEmpty();
        this.data = profile.getData(isClient);
    }

    public Version.Library[] getLibraries() {
        return this.hasTasks ? this.profile.getLibraries() : new Version.Library[]{};
    }

    public int getTaskCount() {
        return this.hasTasks ? 0 : this.profile.getLibraries().length + this.processors.size() + this.profile.getData(this.isClient).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(File librariesDir, File minecraft, File root, File installer) {
        try {
            if (!this.data.isEmpty()) {
                StringBuilder err = new StringBuilder();
                Path temp = Files.createTempDirectory("forge_installer", new FileAttribute[0]);
                this.monitor.start("Created Temporary Directory: " + temp);
                double steps = this.data.size();
                int progress = 1;
                for (String string : this.data.keySet()) {
                    this.monitor.getGlobalProgress().percentageProgress((double)progress++ / steps);
                    String string2 = this.data.get(string);
                    if (string2.charAt(0) == '[' && string2.charAt(string2.length() - 1) == ']') {
                        this.data.put(string, Artifact.from(string2.substring(1, string2.length() - 1)).getLocalPath(librariesDir).getAbsolutePath());
                        continue;
                    }
                    if (string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
                        this.data.put(string, string2.substring(1, string2.length() - 1));
                        continue;
                    }
                    File target = Paths.get(temp.toString(), string2).toFile();
                    this.monitor.message("  Extracting: " + string2);
                    if (!DownloadUtils.extractFile(string2, target)) {
                        err.append("\n  ").append(string2);
                    }
                    this.data.put(string, target.getAbsolutePath());
                }
                if (err.length() > 0) {
                    this.error("Failed to extract files from archive: " + err.toString());
                    return false;
                }
            }
            this.data.put("SIDE", this.isClient ? "client" : "server");
            this.data.put("MINECRAFT_JAR", minecraft.getAbsolutePath());
            this.data.put("MINECRAFT_VERSION", this.profile.getMinecraft());
            this.data.put("ROOT", root.getAbsolutePath());
            this.data.put("INSTALLER", installer.getAbsolutePath());
            this.data.put("LIBRARY_DIR", librariesDir.getAbsolutePath());
            int progress = 0;
            if (this.processors.size() == 1) {
                this.monitor.stage("Building Processor");
            } else {
                this.monitor.start("Building Processors");
            }
            this.monitor.getGlobalProgress().setMaxProgress(this.processors.size());
            Iterator<Install.Processor> iterator = this.processors.iterator();
            while (iterator.hasNext()) {
                boolean end;
                File jar;
                Install.Processor proc = iterator.next();
                this.log("===============================================================================");
                String procName = proc.getJar().getDomain() + ":" + proc.getJar().getName();
                if (proc.getJar().getName().equals("installertools")) {
                    procName = procName + " -> " + proc.getArgs()[Arrays.asList(proc.getArgs()).indexOf("--task") + 1];
                }
                this.monitor.setCurrentStep("Processor: " + procName);
                HashMap<String, String> outputs = new HashMap<String, String>();
                if (!proc.getOutputs().isEmpty()) {
                    boolean miss = false;
                    this.log("  Cache: ");
                    for (Map.Entry<String, String> entry : proc.getOutputs().entrySet()) {
                        String key = entry.getKey();
                        key = key.charAt(0) == '[' && key.charAt(key.length() - 1) == ']' ? Artifact.from(key.substring(1, key.length() - 1)).getLocalPath(librariesDir).getAbsolutePath() : Util.replaceTokens(this.data, key);
                        String value = entry.getValue();
                        if (value != null) {
                            value = Util.replaceTokens(this.data, value);
                        }
                        if (key == null || value == null) {
                            this.error("  Invalid configuration, bad output config: [" + entry.getKey() + ": " + entry.getValue() + "]");
                            return false;
                        }
                        outputs.put(key, value);
                        Artifact[] artifact = new File(key);
                        if (!artifact.exists()) {
                            this.log("    " + key + " Missing");
                            miss = true;
                            continue;
                        }
                        String[] sha = DownloadUtils.getSha1((File)artifact);
                        if (sha.equals(value)) {
                            this.log("    " + key + " Validated: " + value);
                            continue;
                        }
                        this.log("    " + key);
                        this.log("      Expected: " + value);
                        this.log("      Actual:   " + (String)sha);
                        miss = true;
                        artifact.delete();
                    }
                    if (!miss) {
                        this.log("  Cache Hit!");
                        continue;
                    }
                }
                if (!(jar = proc.getJar().getLocalPath(librariesDir)).exists() || !jar.isFile()) {
                    this.error("  Missing Jar for processor: " + jar.getAbsolutePath());
                    return false;
                }
                JarFile jarFile = new JarFile(jar);
                String string = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                jarFile.close();
                if (string == null || string.isEmpty()) {
                    this.error("  Jar does not have main class: " + jar.getAbsolutePath());
                    return false;
                }
                this.monitor.message("  MainClass: " + string, ProgressCallback.MessagePriority.LOW);
                ArrayList<URL> classpath = new ArrayList<URL>();
                StringBuilder err = new StringBuilder();
                this.monitor.message("  Classpath:", ProgressCallback.MessagePriority.LOW);
                this.monitor.message("    " + jar.getAbsolutePath(), ProgressCallback.MessagePriority.LOW);
                classpath.add(jar.toURI().toURL());
                for (Artifact dep : proc.getClasspath()) {
                    File lib = dep.getLocalPath(librariesDir);
                    if (!lib.exists() || !lib.isFile()) {
                        err.append("\n  ").append(dep.getDescriptor());
                    }
                    classpath.add(lib.toURI().toURL());
                    this.monitor.message("    " + lib.getAbsolutePath(), ProgressCallback.MessagePriority.LOW);
                }
                if (err.length() > 0) {
                    this.error("  Missing Processor Dependencies: " + err.toString());
                    return false;
                }
                ArrayList<String> args = new ArrayList<String>();
                for (String arg : proc.getArgs()) {
                    char start = arg.charAt(0);
                    end = arg.charAt(arg.length() - 1);
                    if (start == '[' && end) {
                        args.add(Artifact.from(arg.substring(1, arg.length() - 1)).getLocalPath(librariesDir).getAbsolutePath());
                        continue;
                    }
                    args.add(Util.replaceTokens(this.data, arg));
                }
                if (err.length() > 0) {
                    this.error("  Missing Processor data values: " + err.toString());
                    return false;
                }
                this.monitor.getStepProgress().setIndeterminate(true);
                this.monitor.message("  Args: " + args.stream().map(a -> a.indexOf(32) != -1 || a.indexOf(44) != -1 ? '\"' + a + '\"' : a).collect(Collectors.joining(", ")), ProgressCallback.MessagePriority.LOW);
                URLClassLoader cl = new URLClassLoader(classpath.toArray(new URL[classpath.size()]), this.getParentClassloader());
                Thread currentThread = Thread.currentThread();
                ClassLoader threadClassloader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(cl);
                try {
                    Class<?> cls = Class.forName(string, true, cl);
                    Method main = cls.getDeclaredMethod("main", String[].class);
                    main.invoke(null, new Object[]{args.toArray(new String[args.size()])});
                }
                catch (InvocationTargetException ite) {
                    Throwable e2 = ite.getCause();
                    e2.printStackTrace();
                    if (e2.getMessage() == null) {
                        this.error("Failed to run processor: " + e2.getClass().getName() + "\nSee log for more details.");
                    } else {
                        this.error("Failed to run processor: " + e2.getClass().getName() + ":" + e2.getMessage() + "\nSee log for more details.");
                    }
                    end = false;
                    return end;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (e.getMessage() == null) {
                        this.error("Failed to run processor: " + e.getClass().getName() + "\nSee log for more details.");
                    } else {
                        this.error("Failed to run processor: " + e.getClass().getName() + ":" + e.getMessage() + "\nSee log for more details.");
                    }
                    boolean e2 = false;
                    return e2;
                }
                finally {
                    currentThread.setContextClassLoader(threadClassloader);
                }
                if (!outputs.isEmpty()) {
                    for (Map.Entry e : outputs.entrySet()) {
                        File artifact = new File((String)e.getKey());
                        if (!artifact.exists()) {
                            err.append("\n    ").append((String)e.getKey()).append(" missing");
                            continue;
                        }
                        String sha = DownloadUtils.getSha1(artifact);
                        if (sha.equals(e.getValue())) {
                            this.log("  Output: " + (String)e.getKey() + " Checksum Validated: " + sha);
                            continue;
                        }
                        err.append("\n    ").append((String)e.getKey()).append("\n      Expected: ").append((String)e.getValue()).append("\n      Actual:   ").append(sha);
                        if (SimpleInstaller.debug || artifact.delete()) continue;
                        err.append("\n      Could not delete file");
                    }
                    if (err.length() > 0) {
                        this.error("  Processor failed, invalid outputs:" + err);
                        return false;
                    }
                }
                this.monitor.getGlobalProgress().progress(++progress);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void error(String message) {
        if (!SimpleInstaller.headless) {
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
        for (String line : message.split("\n")) {
            this.monitor.message(line);
        }
    }

    private void log(String message) {
        for (String line : message.split("\n")) {
            this.monitor.message(line);
        }
    }

    private synchronized ClassLoader getParentClassloader() {
        if (!clChecked) {
            clChecked = true;
            if (!System.getProperty("java.version").startsWith("1.")) {
                try {
                    Method getPlatform = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
                    parentClassLoader = (ClassLoader)getPlatform.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    this.log("No platform classloader: " + System.getProperty("java.version"));
                }
            }
        }
        return parentClassLoader;
    }
}

