/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.PostProcessors;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.actions.TargetValidator;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;
import net.minecraftforge.installer.ui.TranslatedMessage;

public abstract class Action {
    protected final InstallV1 profile;
    protected final ProgressCallback monitor;
    protected final PostProcessors processors;
    protected final Version version;
    private List<Artifact> grabbed = new ArrayList<Artifact>();

    protected Action(InstallV1 profile, ProgressCallback monitor, boolean isClient) {
        this.profile = profile;
        this.monitor = monitor;
        this.processors = new PostProcessors(profile, isClient, monitor);
        this.version = Util.loadVersion(profile);
    }

    protected void error(String message) {
        if (!SimpleInstaller.headless) {
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
        this.monitor.stage(message);
    }

    public abstract boolean run(File var1, Predicate<String> var2, File var3) throws ActionCanceledException;

    public abstract TargetValidator getTargetValidator();

    public abstract TranslatedMessage getSuccessMessage();

    public String getSponsorMessage() {
        return this.profile.getMirror() != null && this.profile.getMirror().isAdvertised() ? String.format(SimpleInstaller.headless ? "Data kindly mirrored by %2$s at %1$s" : "<html><a href='%s'>Data kindly mirrored by %s</a></html>", this.profile.getMirror().getHomepage(), this.profile.getMirror().getName()) : null;
    }

    protected boolean downloadLibraries(File librariesDir, Predicate<String> optionals, List<File> additionalLibDirs) throws ActionCanceledException {
        File mavenLocalHome;
        this.monitor.start("Downloading libraries");
        String userHome = System.getProperty("user.home");
        if (userHome != null && !userHome.isEmpty() && (mavenLocalHome = new File(userHome, ".m2/repository")).exists()) {
            additionalLibDirs.add(mavenLocalHome);
        }
        this.monitor.message(String.format("Found %d additional library directories", additionalLibDirs.size()));
        ArrayList<Version.Library> libraries = new ArrayList<Version.Library>();
        libraries.addAll(Arrays.asList(this.version.getLibraries()));
        libraries.addAll(Arrays.asList(this.processors.getLibraries()));
        StringBuilder output = new StringBuilder();
        this.monitor.getStepProgress().setMaxProgress(libraries.size());
        int progress = 0;
        ProgressCallback targetMonitor = this.monitor.withoutDownloadProgress();
        for (Version.Library lib : libraries) {
            this.checkCancel();
            if (!DownloadUtils.downloadLibrary(targetMonitor, this.profile.getMirror(), lib, librariesDir, optionals, this.grabbed, additionalLibDirs)) {
                Version.LibraryDownload download;
                Version.LibraryDownload libraryDownload = download = lib.getDownloads() == null ? null : lib.getDownloads().getArtifact();
                if (download != null && !download.getUrl().isEmpty()) {
                    output.append('\n').append(lib.getName());
                }
            }
            this.monitor.getStepProgress().progress(++progress);
        }
        String bad = output.toString();
        if (!bad.isEmpty()) {
            this.error("These libraries failed to download. Try again.\n" + bad);
            return false;
        }
        return true;
    }

    protected int downloadedCount() {
        return this.grabbed.size();
    }

    protected int getTaskCount() {
        return this.profile.getLibraries().length + this.processors.getTaskCount();
    }

    protected void checkCancel() throws ActionCanceledException {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new ActionCanceledException(e);
        }
    }
}

