/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.actions.TargetValidator;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;
import net.minecraftforge.installer.ui.TranslatedMessage;

public class ClientInstall
extends Action {
    public ClientInstall(InstallV1 profile, ProgressCallback monitor) {
        super(profile, monitor, true);
    }

    @Override
    public boolean run(File target, Predicate<String> optionals, File installer) throws ActionCanceledException {
        if (!target.exists()) {
            this.error("There is no minecraft installation at: " + target);
            return false;
        }
        File launcherProfiles = new File(target, "launcher_profiles.json");
        File launcherProfilesMS = new File(target, "launcher_profiles_microsoft_store.json");
        if (!launcherProfiles.exists() && !launcherProfilesMS.exists()) {
            this.error("There is no minecraft launcher profile in \"" + target + "\", you need to run the launcher first!");
            return false;
        }
        File versionRoot = new File(target, "versions");
        File librariesDir = new File(target, "libraries");
        librariesDir.mkdir();
        this.checkCancel();
        this.monitor.stage("Extracting json");
        try (InputStream stream = Util.class.getResourceAsStream(this.profile.getJson());){
            File json = new File(versionRoot, this.profile.getVersion() + '/' + this.profile.getVersion() + ".json");
            json.getParentFile().mkdirs();
            Files.copy(stream, json.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.error("  Failed to extract");
            e.printStackTrace();
            return false;
        }
        this.checkCancel();
        this.monitor.stage("Considering minecraft client jar");
        File versionVanilla = new File(versionRoot, this.profile.getMinecraft());
        if (!versionVanilla.mkdirs() && !versionVanilla.isDirectory()) {
            if (!versionVanilla.delete()) {
                this.error("There was a problem with the launcher version data. You will need to clear " + versionVanilla + " manually.");
                return false;
            }
            versionVanilla.mkdirs();
        }
        this.checkCancel();
        File clientTarget = new File(versionVanilla, this.profile.getMinecraft() + ".jar");
        if (!clientTarget.exists()) {
            File versionJson = new File(versionVanilla, this.profile.getMinecraft() + ".json");
            Version vanilla = Util.getVanillaVersion(this.profile.getMinecraft(), versionJson);
            if (vanilla == null) {
                this.error("Failed to download version manifest, can not find client jar URL.");
                return false;
            }
            Version.Download client = vanilla.getDownload("client");
            if (client == null) {
                this.error("Failed to download minecraft client, info missing from manifest: " + versionJson);
                return false;
            }
            if (!DownloadUtils.download(this.monitor, this.profile.getMirror(), client, clientTarget)) {
                clientTarget.delete();
                this.error("Downloading minecraft client failed, invalid checksum.\nTry again, or use the vanilla launcher to install the vanilla version.");
                return false;
            }
        }
        if (!this.downloadLibraries(librariesDir, optionals, new ArrayList<File>())) {
            return false;
        }
        this.checkCancel();
        if (!this.processors.process(librariesDir, clientTarget, target, installer)) {
            return false;
        }
        this.checkCancel();
        this.monitor.stage("Injecting profile");
        if (launcherProfiles.exists() && !this.injectProfile(launcherProfiles)) {
            return false;
        }
        return !launcherProfilesMS.exists() || this.injectProfile(launcherProfilesMS);
    }

    private boolean injectProfile(File target) {
        try {
            JsonObject _profile;
            JsonObject json = null;
            try (FileInputStream stream = new FileInputStream(target);){
                json = JsonParser.parseReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8)).getAsJsonObject();
            }
            catch (IOException e) {
                this.error("Failed to read " + target);
                e.printStackTrace();
                return false;
            }
            JsonObject _profiles = json.getAsJsonObject("profiles");
            if (_profiles == null) {
                _profiles = new JsonObject();
                json.add("profiles", _profiles);
            }
            if ((_profile = _profiles.getAsJsonObject(this.profile.getProfile())) == null) {
                _profile = new JsonObject();
                _profile.addProperty("name", this.profile.getProfile());
                _profile.addProperty("type", "custom");
                _profiles.add(this.profile.getProfile(), _profile);
            }
            _profile.addProperty("lastVersionId", this.profile.getVersion());
            String icon = this.profile.getIcon();
            if (icon != null) {
                _profile.addProperty("icon", icon);
            }
            String jstring = Util.GSON.toJson(json);
            Files.write(target.toPath(), jstring.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            this.error("There was a problem writing the launch profile,  is it write protected?");
            return false;
        }
        return true;
    }

    @Override
    public TargetValidator getTargetValidator() {
        return TargetValidator.shouldExist(true).and(TargetValidator.isDirectory()).and(TargetValidator.isMCInstallationDirectory());
    }

    @Override
    public TranslatedMessage getSuccessMessage() {
        if (this.downloadedCount() > 0) {
            return new TranslatedMessage("installer.action.install.client.finished.withlibs", this.profile.getProfile(), this.profile.getVersion(), this.downloadedCount());
        }
        return new TranslatedMessage("installer.action.install.client.finished.withoutlibs", this.profile.getProfile(), this.profile.getVersion());
    }
}

