/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Manifest;
import net.minecraftforge.installer.json.Mirror;
import net.minecraftforge.installer.json.Spec;
import net.minecraftforge.installer.json.Version;

public class Util {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Artifact.class, (Object)new Artifact.Adapter()).create();

    public static InstallV1 loadInstallProfile() {
        byte[] data = null;
        try (InputStream stream = Util.class.getResourceAsStream("/install_profile.json");){
            data = Util.readFully(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Spec spec = (Spec)GSON.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8), Spec.class);
        switch (spec.getSpec()) {
            case 0: {
                return new InstallV1((Install)GSON.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8), Install.class));
            }
            case 1: {
                return (InstallV1)GSON.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8), InstallV1.class);
            }
        }
        throw new IllegalArgumentException("Invalid launcher profile spec: " + spec.getSpec() + " Only 0, and 1 are supported");
    }

    public static Mirror[] loadMirrorList(InputStream stream) {
        return (Mirror[])GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Mirror[].class);
    }

    public static Manifest loadManifest(InputStream stream) {
        return (Manifest)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Manifest.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version loadVersion(Install profile) {
        try (InputStream stream = Util.class.getResourceAsStream(profile.getJson());){
            Version version = (Version)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Version.class);
            return version;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version getVanillaVersion(ProgressCallback callback, String version, File target) {
        if (!target.exists()) {
            Manifest manifest = DownloadUtils.downloadManifest(callback);
            if (manifest == null) {
                return null;
            }
            Manifest.Info ver = manifest.get(version);
            if (ver == null) {
                return null;
            }
            if (!callback.downloader(ver.getUrl()).localPath("minecraft/" + version + ".json").sha(ver.sha1).download(target)) {
                return null;
            }
        }
        try (FileInputStream stream = new FileInputStream(target);){
            Version version2 = (Version)GSON.fromJson((Reader)new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8), Version.class);
            return version2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version getVersionUncached(ProgressCallback callback, String url) {
        try (InputStream stream = callback.downloader(url).openStream();){
            Version version = (Version)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), Version.class);
            return version;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    public static String replaceTokens(Map<String, String> tokens, String value) {
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '\\') {
                if (x == value.length() - 1) {
                    throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                }
                buf.append(value.charAt(++x));
                continue;
            }
            if (c == '{' || c == '\'') {
                StringBuilder key = new StringBuilder();
                for (int y = x + 1; y <= value.length(); ++y) {
                    if (y == value.length()) {
                        throw new IllegalArgumentException("Illegal pattern (Unclosed " + c + "): " + value);
                    }
                    char d = value.charAt(y);
                    if (d == '\\') {
                        if (y == value.length() - 1) {
                            throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                        }
                        key.append(value.charAt(++y));
                        continue;
                    }
                    if (c == '{' && d == '}') {
                        x = y;
                        break;
                    }
                    if (c == '\'' && d == '\'') {
                        x = y;
                        break;
                    }
                    key.append(d);
                }
                if (c == '\'') {
                    buf.append((CharSequence)key);
                    continue;
                }
                if (!tokens.containsKey(key.toString())) {
                    throw new IllegalArgumentException("Illegal pattern: " + value + " Missing Key: " + key);
                }
                buf.append(tokens.get(key.toString()));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

