/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.ui.Images;
import net.minecraftforge.installer.ui.InstallerPanel;
import net.minecraftforge.installer.ui.TranslationTarget;

public class ProgressFrame
extends JFrame
implements ProgressCallback {
    private static final long serialVersionUID = 1L;
    private final ProgressCallback parent;
    private final JPanel panel = new JPanel();
    private final JLabel progressText;
    private final JProgressBar globalProgress;
    private final ProgressCallback.ProgressBar globalProgressController;
    private final JProgressBar stepProgress;
    private final ProgressCallback.ProgressBar stepProgressController;
    private final JTextArea consoleArea;
    private String step;

    public ProgressFrame(ProgressCallback parent, Runnable canceler, String titleKey, Object ... titleArgs) {
        int gridY = 0;
        this.parent = parent;
        this.setResizable(false);
        InstallerPanel.TRANSLATIONS.translate(this, new TranslationTarget<ProgressFrame>(Frame::setTitle), titleKey, titleArgs);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 600, 400);
        this.setContentPane(this.panel);
        this.setLocationRelativeTo(null);
        this.setIconImages(Images.getWindowIcons());
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{600, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 200};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
        this.panel.setLayout(gridBagLayout);
        this.progressText = new JLabel("Progress Text");
        GridBagConstraints gbc_lblProgressText = new GridBagConstraints();
        gbc_lblProgressText.insets = new Insets(10, 0, 5, 0);
        gbc_lblProgressText.gridx = 0;
        gbc_lblProgressText.gridy = gridY++;
        this.panel.add((Component)this.progressText, gbc_lblProgressText);
        this.globalProgress = new JProgressBar();
        this.globalProgressController = ProgressFrame.wrapSwing(this.globalProgress);
        GridBagConstraints gbc_progressBar = new GridBagConstraints();
        gbc_progressBar.insets = new Insets(0, 25, 5, 25);
        gbc_progressBar.fill = 2;
        gbc_progressBar.gridx = 0;
        gbc_progressBar.gridy = gridY++;
        this.panel.add((Component)this.globalProgress, gbc_progressBar);
        this.stepProgress = new JProgressBar();
        this.stepProgressController = ProgressFrame.wrapSwing(this.stepProgress);
        GridBagConstraints gbc_stepProgress = new GridBagConstraints();
        gbc_stepProgress.insets = new Insets(0, 25, 5, 25);
        gbc_stepProgress.fill = 2;
        gbc_stepProgress.gridx = 0;
        gbc_stepProgress.gridy = gridY++;
        this.panel.add((Component)this.stepProgress, gbc_stepProgress);
        JButton btnCancel = InstallerPanel.TRANSLATIONS.button("installer.button.cancel", new Object[0]);
        btnCancel.addActionListener(e -> {
            canceler.run();
            this.dispose();
        });
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.insets = new Insets(0, 25, 5, 25);
        gbc_btnCancel.fill = 2;
        gbc_btnCancel.gridx = 0;
        gbc_btnCancel.gridy = gridY++;
        this.panel.add((Component)btnCancel, gbc_btnCancel);
        this.consoleArea = new JTextArea();
        this.consoleArea.setFont(new Font("Monospaced", 0, 11));
        GridBagConstraints gbc_textArea = new GridBagConstraints();
        gbc_textArea.insets = new Insets(15, 25, 25, 25);
        gbc_textArea.fill = 1;
        gbc_textArea.gridx = 0;
        gbc_textArea.gridy = gridY;
        JScrollPane scroll = new JScrollPane(this.consoleArea, 22, 30);
        scroll.setAutoscrolls(true);
        this.panel.add((Component)scroll, gbc_textArea);
    }

    @Override
    public void start(String label) {
        this.message(label, ProgressCallback.MessagePriority.HIGH, false);
        this.globalProgress.setValue(0);
        this.globalProgress.setIndeterminate(false);
        this.parent.start(label);
    }

    @Override
    public void stage(String message, boolean withProgress) {
        this.message(message, ProgressCallback.MessagePriority.HIGH, false);
        this.globalProgress.setIndeterminate(true);
        this.parent.stage(message);
        this.stepProgress.setIndeterminate(!withProgress);
        this.stepProgress.setMaximum(100);
        this.stepProgress.setValue(0);
        this.stepProgress.setToolTipText(message);
    }

    @Override
    public ProgressCallback.ProgressBar getStepProgress() {
        return this.stepProgressController;
    }

    @Override
    public ProgressCallback.ProgressBar getGlobalProgress() {
        return this.globalProgressController;
    }

    @Override
    public String getCurrentStep() {
        return this.step;
    }

    @Override
    public void setCurrentStep(String step) {
        this.message(step, ProgressCallback.MessagePriority.HIGH);
        this.step = step;
    }

    @Override
    public void message(String message, ProgressCallback.MessagePriority priority) {
        this.message(message, priority, true);
    }

    public void message(String message, ProgressCallback.MessagePriority priority, boolean notifyParent) {
        if (priority == ProgressCallback.MessagePriority.HIGH) {
            this.progressText.setText(message);
        }
        this.consoleArea.append(message + "\n");
        this.consoleArea.setCaretPosition(this.consoleArea.getDocument().getLength());
        if (notifyParent) {
            this.parent.message(message, priority);
        }
    }

    private static ProgressCallback.ProgressBar wrapSwing(final JProgressBar bar) {
        return new ProgressCallback.ProgressBar(){

            @Override
            public void setMaxProgress(int maximum) {
                if (maximum != -1) {
                    bar.setMaximum(maximum);
                    bar.setIndeterminate(false);
                }
            }

            @Override
            public void progress(int value) {
                bar.setValue(value);
            }

            @Override
            public void percentageProgress(double value) {
                bar.setValue((int)value * 100);
            }

            @Override
            public void setIndeterminate(boolean indeterminate) {
                bar.setIndeterminate(indeterminate);
            }
        };
    }
}

