/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ClientInstall;
import net.minecraftforge.installer.actions.ExtractAction;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.actions.ServerInstall;
import net.minecraftforge.installer.json.InstallV1;

public enum Actions {
    CLIENT("installer.action.install.client.name", "installer.action.install.client.tooltip", ClientInstall::new, () -> "Successfully installed client into launcher."),
    SERVER("installer.action.install.server.name", "installer.action.install.server.tooltip", ServerInstall::new, () -> "The server installed successfully"),
    EXTRACT("installer.action.extract.name", "installer.action.extract.tooltip", ExtractAction::new, () -> "All files successfully extract.");

    private String label;
    private String tooltip;
    private BiFunction<InstallV1, ProgressCallback, Action> action;
    private Supplier<String> success;

    private Actions(String label, String tooltip, BiFunction<InstallV1, ProgressCallback, Action> action, Supplier<String> success) {
        this.label = label;
        this.tooltip = tooltip;
        this.success = success;
        this.action = action;
    }

    public String getButtonLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getSuccess() {
        return this.success.get();
    }

    public Action getAction(InstallV1 profile, ProgressCallback monitor) {
        return this.action.apply(profile, monitor);
    }
}

