/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.intellij;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Map;
import net.neoforged.jst.cli.intellij.CoreJrtVirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJrtVirtualFile> roots = ConcurrentFactoryMap.createMap(jdkHomePath -> {
        FileSystem fileSystem;
        File jdkHome = new File((String)jdkHomePath);
        File jrtFsJar = CoreJrtFileSystem.getJrtFsJar(jdkHome);
        if (!jrtFsJar.exists()) {
            return null;
        }
        URI rootUri = URI.create("jrt:/");
        try {
            fileSystem = FileSystems.newFileSystem(rootUri, Map.of("java.home", jdkHome.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new CoreJrtVirtualFile(this, (String)jdkHomePath, fileSystem.getPath("", new String[0]), null);
    });

    CoreJrtFileSystem() {
    }

    @NonNls
    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        JdkImagePath splitPath = CoreJrtFileSystem.splitPath(path);
        String jdkHomePath = splitPath.jdkHome;
        String pathInImage = splitPath.pathInImage;
        CoreJrtVirtualFile root = this.roots.get(jdkHomePath);
        if (root == null) {
            return null;
        }
        if (pathInImage.isEmpty()) {
            return root;
        }
        return root.findFileByRelativePath(pathInImage);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    private void clearRoots() {
        this.roots.clear();
    }

    private static File getJrtFsJar(File jdkHome) {
        return new File(jdkHome, "lib/jrt-fs.jar");
    }

    static boolean isModularJdk(File jdkHome) {
        return CoreJrtFileSystem.getJrtFsJar(jdkHome).exists();
    }

    private static JdkImagePath splitPath(String path) {
        int separator = path.indexOf("!/");
        if (separator < 0) {
            throw new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path);
        }
        String localPath = path.substring(0, separator);
        String pathInJar = path.substring(separator + "!/".length());
        return new JdkImagePath(localPath, pathInJar);
    }

    record JdkImagePath(String jdkHome, String pathInImage) {
    }
}

