/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.intellij;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.facade.JvmElementProvider;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.pom.java.InternalPersistentJavaLanguageLevelReaderService;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.JavaClassSupersImpl;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.source.tree.JavaTreeGenerator;
import com.intellij.psi.impl.source.tree.TreeGenerator;
import com.intellij.psi.util.JavaClassSupers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.neoforged.jst.api.IntelliJEnvironment;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.cli.intellij.ClasspathSetup;
import net.neoforged.jst.cli.intellij.CoreJrtFileSystem;
import org.jetbrains.annotations.VisibleForTesting;

public class IntelliJEnvironmentImpl
implements IntelliJEnvironment,
AutoCloseable {
    private final Logger logger;
    private final Disposable rootDisposable;
    private final Path tempDir;
    private final MockProject project;
    private final JavaCoreProjectEnvironment javaEnv;
    private final PsiManager psiManager;

    public IntelliJEnvironmentImpl(Logger logger) throws IOException {
        this.logger = logger;
        System.setProperty("java.awt.headless", "true");
        this.tempDir = Files.createTempDirectory("jst", new FileAttribute[0]);
        this.rootDisposable = Disposer.newDisposable();
        System.setProperty("idea.home.path", this.tempDir.toAbsolutePath().toString());
        PathManager.setExplicitConfigPath((String)this.tempDir.toAbsolutePath().toString());
        Registry.markAsLoaded();
        JavaCoreApplicationEnvironment appEnv = new JavaCoreApplicationEnvironment(this.rootDisposable){

            protected VirtualFileSystem createJrtFileSystem() {
                return new CoreJrtFileSystem();
            }
        };
        this.initAppExtensionsAndServices(appEnv);
        this.javaEnv = new JavaCoreProjectEnvironment(this.rootDisposable, (CoreApplicationEnvironment)appEnv);
        this.project = this.javaEnv.getProject();
        this.initProjectExtensionsAndServices(this.project);
        LanguageLevelProjectExtension.getInstance((Project)this.project).setLanguageLevel(LanguageLevel.JDK_17);
        this.psiManager = PsiManager.getInstance((Project)this.project);
    }

    public PsiManager getPsiManager() {
        return this.psiManager;
    }

    public CoreApplicationEnvironment getAppEnv() {
        return this.javaEnv.getEnvironment();
    }

    public JavaCoreProjectEnvironment getProjectEnv() {
        return this.javaEnv;
    }

    public void addJarToClassPath(Path jarFile) {
        this.javaEnv.addJarToClassPath(jarFile.toFile());
    }

    public void addFolderToClasspath(Path folder) {
        VirtualFile localFile = this.getAppEnv().getLocalFileSystem().findFileByNioFile(folder);
        Objects.requireNonNull(localFile);
        this.javaEnv.addSourcesToClasspath(localFile);
    }

    public void addSourceRoot(VirtualFile sourceRoot) {
        this.javaEnv.addSourcesToClasspath(sourceRoot);
    }

    public void addCurrentJdkToClassPath() {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        ClasspathSetup.addJdkModules(this.logger, javaHome, this.javaEnv);
    }

    @Override
    public void close() throws IOException {
        ZipHandler.clearFileAccessorCache();
        Disposer.dispose((Disposable)this.rootDisposable);
        Files.deleteIfExists(this.tempDir);
    }

    @VisibleForTesting
    public PsiFile parseFileFromMemory(String filename, String fileContent) {
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)this.project);
        return fileFactory.createFileFromText(filename, (Language)JavaLanguage.INSTANCE, (CharSequence)fileContent);
    }

    private void initProjectExtensionsAndServices(MockProject project) {
        project.registerService(PsiNameHelper.class, PsiNameHelperImpl.class);
        ExtensionsAreaImpl projectExtensions = project.getExtensionArea();
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)projectExtensions, (String)PsiTreeChangePreprocessor.EP.getName(), PsiTreeChangePreprocessor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)projectExtensions, (String)PsiElementFinder.EP.getName(), PsiElementFinder.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)projectExtensions, (ExtensionPointName)JvmElementProvider.EP_NAME, JvmElementProvider.class);
        PsiElementFinder.EP.getPoint((AreaInstance)project).registerExtension((Object)new PsiElementFinderImpl((Project)project), this.rootDisposable);
    }

    private void initAppExtensionsAndServices(JavaCoreApplicationEnvironment appEnv) {
        appEnv.registerApplicationService(JavaClassSupers.class, (Object)new JavaClassSupersImpl());
        appEnv.registerApplicationService(InternalPersistentJavaLanguageLevelReaderService.class, (Object)new InternalPersistentJavaLanguageLevelReaderService.DefaultImpl());
        appEnv.registerApplicationService(TransactionGuard.class, (Object)new TransactionGuardImpl());
        ExtensionsAreaImpl appExtensions = appEnv.getApplication().getExtensionArea();
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)appExtensions, (ExtensionPointName)PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)appExtensions, (ExtensionPointName)JavaModuleSystem.EP_NAME, JavaModuleSystem.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)appExtensions, (ExtensionPointName)TreeGenerator.EP_NAME, TreeGenerator.class);
        appExtensions.getExtensionPoint(TreeGenerator.EP_NAME).registerExtension((Object)new JavaTreeGenerator(), this.rootDisposable);
    }
}

