/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.jst.api.FileEntry;
import net.neoforged.jst.api.FileSink;
import net.neoforged.jst.api.FileSource;
import net.neoforged.jst.api.IntelliJEnvironment;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import net.neoforged.jst.cli.OrderedParallelWorkQueue;
import net.neoforged.jst.cli.intellij.ClasspathSetup;
import net.neoforged.jst.cli.intellij.IntelliJEnvironmentImpl;

class SourceFileProcessor
implements AutoCloseable {
    private final IntelliJEnvironmentImpl ijEnv;
    private int maxQueueDepth = 50;
    private final Logger logger;

    public SourceFileProcessor(Logger logger) throws IOException {
        this.logger = logger;
        this.ijEnv = new IntelliJEnvironmentImpl(logger);
        this.ijEnv.addCurrentJdkToClassPath();
    }

    public boolean process(FileSource source, FileSink sink, List<SourceTransformer> transformers) throws IOException {
        if (source.canHaveMultipleEntries() && !sink.canHaveMultipleEntries()) {
            throw new IllegalStateException("Cannot have an input with possibly more than one file when the output is a single file.");
        }
        TransformContext context = new TransformContext((IntelliJEnvironment)this.ijEnv, source, sink, this.logger);
        VirtualFile sourceRoot = source.createSourceRoot(VirtualFileManager.getInstance());
        this.ijEnv.addSourceRoot(sourceRoot);
        for (SourceTransformer transformer : transformers) {
            transformer.beforeRun(context);
        }
        if (source.isOrdered() && sink.isOrdered()) {
            try (Stream stream = source.streamEntries();){
                stream.forEach(entry -> {
                    try {
                        this.processEntry((FileEntry)entry, sourceRoot, transformers, sink);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        try (OrderedParallelWorkQueue asyncOut = new OrderedParallelWorkQueue(sink, this.maxQueueDepth);
             Stream stream = source.streamEntries();){
            stream.forEach(entry -> asyncOut.submitAsync(parallelSink -> {
                try {
                    this.processEntry((FileEntry)entry, sourceRoot, transformers, (FileSink)parallelSink);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }));
        }
        boolean isOk = true;
        for (SourceTransformer transformer : transformers) {
            isOk = isOk && transformer.afterRun(context);
        }
        return isOk;
    }

    private void processEntry(FileEntry entry, VirtualFile sourceRoot, List<SourceTransformer> transformers, FileSink sink) throws IOException {
        if (entry.directory()) {
            sink.putDirectory(entry.relativePath());
            return;
        }
        try (InputStream in = entry.openInputStream();){
            byte[] orgContent;
            byte[] content = in.readAllBytes();
            FileTime lastModified = entry.lastModified();
            if (!transformers.isEmpty() && entry.hasExtension("java") && (orgContent = content) != (content = this.transformSource(sourceRoot, entry.relativePath(), transformers, content))) {
                lastModified = FileTime.from(Instant.now());
            }
            sink.putFile(entry.relativePath(), lastModified, content);
        }
    }

    byte[] transformSource(VirtualFile contentRoot, String path, List<SourceTransformer> transformers, byte[] originalContentBytes) {
        VirtualFile sourceFile = contentRoot.findFileByRelativePath(path);
        if (sourceFile == null) {
            System.err.println("Can't transform " + path + " since IntelliJ doesn't see it in the source jar.");
            return originalContentBytes;
        }
        PsiFile psiFile = this.ijEnv.getPsiManager().findFile(sourceFile);
        if (psiFile == null) {
            System.err.println("Can't transform " + path + " since IntelliJ can't load it.");
            return originalContentBytes;
        }
        Replacements replacements = new Replacements();
        for (SourceTransformer transformer : transformers) {
            transformer.visitFile(psiFile, replacements);
        }
        if (replacements.isEmpty()) {
            return originalContentBytes;
        }
        CharSequence originalContent = psiFile.getViewProvider().getContents();
        return replacements.apply(originalContent).getBytes(StandardCharsets.UTF_8);
    }

    public void setMaxQueueDepth(int maxQueueDepth) {
        this.maxQueueDepth = maxQueueDepth;
    }

    public void addLibrariesList(Path librariesList) throws IOException {
        ClasspathSetup.addLibraries(this.logger, librariesList, this.ijEnv);
    }

    public void addLibrary(Path library) {
        ClasspathSetup.addLibrary(this.logger, library, this.ijEnv);
    }

    @Override
    public void close() throws IOException {
        this.ijEnv.close();
    }
}

