/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import net.neoforged.jst.api.FileSink;
import net.neoforged.jst.api.FileSource;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.SourceTransformerPlugin;
import net.neoforged.jst.cli.ClasspathConverter;
import net.neoforged.jst.cli.PathType;
import net.neoforged.jst.cli.SourceFileProcessor;
import net.neoforged.jst.cli.io.FileSinks;
import net.neoforged.jst.cli.io.FileSources;
import org.jetbrains.annotations.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="jst", mixinStandardHelpOptions=true, usageHelpWidth=100)
public class Main
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", paramLabel="INPUT", description={"Path to a single Java-file, a source-archive or a folder containing the source to transform."})
    Path inputPath;
    @CommandLine.Parameters(index="1", paramLabel="OUTPUT", description={"Path to where the resulting source should be placed."})
    Path outputPath;
    @CommandLine.Option(names={"--in-format"}, description={"Specify the format of INPUT explicitly. AUTO (the default) performs auto-detection. Other options are SINGLE_FILE for Java files, ARCHIVE for source jars or zips, and FOLDER for folders containing Java code."})
    PathType inputFormat = PathType.AUTO;
    @CommandLine.Option(names={"--out-format"}, description={"Specify the format of OUTPUT explicitly. Allows the same options as --in-format."})
    PathType outputFormat = PathType.AUTO;
    @CommandLine.Option(names={"--libraries-list"}, description={"Specifies a file that contains a path to an archive or directory to add to the classpath on each line."})
    Path librariesList;
    @CommandLine.Option(names={"--classpath"}, description={"Additional classpath entries to use. Is combined with --libraries-list."}, converter={ClasspathConverter.class})
    List<Path> addToClasspath = new ArrayList<Path>();
    @CommandLine.Option(names={"--max-queue-depth"}, description={"When both input and output support ordering (archives), the transformer will try to maintain that order. To still process items in parallel, a queue is used. Larger queue depths lead to higher memory usage."})
    int maxQueueDepth = 100;
    @CommandLine.Command(name="--debug", description={"Print additional debugging information"})
    boolean debug = false;
    private final HashSet<SourceTransformer> enabledTransformers = new HashSet();

    public static void main(String[] args) {
        System.exit(Main.innerMain(args));
    }

    @VisibleForTesting
    public static int innerMain(String ... args) {
        List<SourceTransformerPlugin> plugins = ServiceLoader.load(SourceTransformerPlugin.class).stream().map(ServiceLoader.Provider::get).toList();
        Main main = new Main();
        CommandLine commandLine = new CommandLine((Object)main);
        commandLine.setCaseInsensitiveEnumValuesAllowed(true);
        CommandLine.Model.CommandSpec spec = commandLine.getCommandSpec();
        main.setupPluginCliOptions(plugins, spec);
        return commandLine.execute(args);
    }

    @Override
    public Integer call() throws Exception {
        Logger logger = this.debug ? new Logger(System.out, System.err) : new Logger(null, System.err);
        try (FileSource source = FileSources.create(this.inputPath, this.inputFormat);
             SourceFileProcessor processor = new SourceFileProcessor(logger);){
            if (this.librariesList != null) {
                processor.addLibrariesList(this.librariesList);
            }
            for (Path path : this.addToClasspath) {
                processor.addLibrary(path);
            }
            processor.setMaxQueueDepth(this.maxQueueDepth);
            ArrayList<SourceTransformer> orderedTransformers = new ArrayList<SourceTransformer>(this.enabledTransformers);
            try (FileSink sink = FileSinks.create(this.outputPath, this.outputFormat, source);){
                if (!processor.process(source, sink, orderedTransformers)) {
                    logger.error("Transformation failed", new Object[0]);
                    Integer n = 1;
                    return n;
                }
            }
        }
        return 0;
    }

    private void setupPluginCliOptions(List<SourceTransformerPlugin> plugins, CommandLine.Model.CommandSpec spec) {
        for (SourceTransformerPlugin plugin : plugins) {
            final SourceTransformer transformer = plugin.createTransformer();
            CommandLine.Model.ArgGroupSpec.Builder builder = CommandLine.Model.ArgGroupSpec.builder();
            builder.exclusive(false).heading("Plugin - " + plugin.getName() + "%n");
            builder.addArg((CommandLine.Model.ArgSpec)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--enable-" + plugin.getName()), (String[])new String[0]).type(Boolean.TYPE)).required(true)).setter(new CommandLine.Model.ISetter(){

                public <T> T set(T value) {
                    boolean previous = Main.this.enabledTransformers.contains(transformer);
                    if (((Boolean)value).booleanValue()) {
                        Main.this.enabledTransformers.add(transformer);
                    } else {
                        Main.this.enabledTransformers.remove(transformer);
                    }
                    return (T)Boolean.valueOf(previous);
                }
            })).description(new String[]{"Enable " + plugin.getName()})).build());
            CommandLine.Model.CommandSpec transformerSpec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)transformer);
            for (CommandLine.Model.OptionSpec option : transformerSpec.options()) {
                builder.addArg((CommandLine.Model.ArgSpec)option);
            }
            spec.addArgGroup(builder.build());
        }
    }
}

