/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.io;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.neoforged.jst.api.FileEntries;
import net.neoforged.jst.api.FileEntry;
import net.neoforged.jst.api.FileSource;

record FolderFileSource(Path path) implements FileSource,
AutoCloseable
{
    public VirtualFile createSourceRoot(VirtualFileManager vfsManager) {
        return vfsManager.findFileByNioPath(this.path);
    }

    public Stream<FileEntry> streamEntries() throws IOException {
        return Files.walk(this.path, new FileVisitOption[0]).filter(p -> !p.equals(this.path)).map(child -> FileEntries.ofPath((Path)this.path, (Path)child));
    }

    public boolean canHaveMultipleEntries() {
        return true;
    }

    public boolean isOrdered() {
        return false;
    }
}

