/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.metadata.ImmutableReference;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;

public final class ReferenceBuilder
implements Reference {
    private Named owner = Named.empty();
    private Named name = Named.empty();
    private Named descriptor = Named.empty();
    private Named signature = Named.empty();

    private ReferenceBuilder() {
    }

    public static ReferenceBuilder create(Reference methodReference) {
        if (methodReference == null) {
            return ReferenceBuilder.create();
        }
        return ReferenceBuilder.create().withOwner(methodReference.getOwner()).withName(methodReference.getName()).withDescriptor(methodReference.getDescriptor()).withSignature(methodReference.getSignature());
    }

    public static ReferenceBuilder create() {
        return new ReferenceBuilder();
    }

    public ReferenceBuilder withSignature(Named signature) {
        this.signature = signature;
        return this;
    }

    public ReferenceBuilder withDescriptor(Named descriptor2) {
        this.descriptor = descriptor2;
        return this;
    }

    public ReferenceBuilder withName(Named name) {
        this.name = name;
        return this;
    }

    public ReferenceBuilder withOwner(Named owner) {
        this.owner = owner;
        return this;
    }

    public ReferenceBuilder merge(@Nullable Reference source) {
        if (source == null) {
            return this;
        }
        this.owner = NamedBuilder.create(this.owner).merge(source.getOwner()).build();
        this.name = NamedBuilder.create(this.name).merge(source.getName()).build();
        this.descriptor = NamedBuilder.create(this.descriptor).merge(source.getDescriptor()).build();
        this.signature = NamedBuilder.create(this.signature).merge(source.getSignature()).build();
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.getOwner(), this.getName(), this.getDescriptor(), this.getSignature());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference that = (Reference)o;
        return Objects.equals(this.getOwner(), that.getOwner()) && this.getName().equals(that.getName()) && this.getDescriptor().equals(that.getDescriptor());
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }

    @Override
    public @NonNull Named getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    @Override
    public @NonNull Reference toImmutable() {
        return this.build();
    }

    public ImmutableReference build() {
        return new ImmutableReference((Named)this.owner.toImmutable(), (Named)this.name.toImmutable(), (Named)this.descriptor.toImmutable(), (Named)this.signature.toImmutable());
    }
}

