/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.AbstractReference;
import org.parchmentmc.feather.metadata.BouncingTargetMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.named.Named;

final class ImmutableMethodMetadata
extends AbstractReference
implements MethodMetadata {
    private final boolean lambda;
    private final BouncingTargetMetadata bouncingTarget;
    private final LinkedHashSet<Reference> overrides;
    private final int securitySpecification;
    private final int startLine;
    private final int endLine;
    private final Reference parent;

    public ImmutableMethodMetadata(Named owner, boolean lambda, BouncingTargetMetadata bouncingTarget, Reference parent, LinkedHashSet<Reference> overrides, Named name, int securitySpecification, Named descriptor2, Named signature, int startLine, int endLine) {
        super(owner, name, descriptor2, signature);
        this.lambda = lambda;
        this.bouncingTarget = bouncingTarget;
        this.parent = parent;
        this.overrides = new LinkedHashSet<Reference>(overrides);
        this.securitySpecification = securitySpecification;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    @Override
    public boolean isLambda() {
        return this.lambda;
    }

    @Override
    public Optional<BouncingTargetMetadata> getBouncingTarget() {
        return Optional.ofNullable(this.bouncingTarget);
    }

    @Override
    public Optional<Reference> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public @NonNull LinkedHashSet<Reference> getOverrides() {
        return this.overrides;
    }

    @Override
    public @NonNull Optional<Integer> getStartLine() {
        if (this.startLine <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.startLine);
    }

    @Override
    public @NonNull Optional<Integer> getEndLine() {
        if (this.endLine <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.endLine);
    }

    @Override
    public int getSecuritySpecification() {
        return this.securitySpecification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMethodMetadata)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableMethodMetadata that = (ImmutableMethodMetadata)o;
        return this.isLambda() == that.isLambda() && this.getSecuritySpecification() == that.getSecuritySpecification() && this.getStartLine().equals(that.getStartLine()) && this.getEndLine().equals(that.getEndLine()) && Objects.equals(this.getBouncingTarget(), that.getBouncingTarget()) && Objects.equals(this.getOverrides(), that.getOverrides());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isLambda(), this.getBouncingTarget(), this.getOverrides(), this.getSecuritySpecification(), this.getStartLine(), this.getEndLine());
    }

    public String toString() {
        return "ImmutableMethodMetadata{owner=" + this.owner + ", name=" + this.name + ", descriptor=" + this.descriptor + ", signature=" + this.signature + ", lambda=" + this.lambda + ", bouncingTarget=" + this.bouncingTarget + ", overrides=" + this.overrides + ", securitySpecification=" + this.securitySpecification + ", startLine=" + this.startLine + ", endLine=" + this.endLine + '}';
    }

    @Override
    public @NonNull MethodMetadata toImmutable() {
        return this;
    }
}

