/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.mapping;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface MappingDataContainer {
    public Collection<? extends PackageData> getPackages();

    public Collection<? extends ClassData> getClasses();

    public @Nullable PackageData getPackage(String var1);

    public @Nullable ClassData getClass(String var1);

    public static interface ParameterData {
        public static final Comparator<ParameterData> COMPARATOR = Comparator.comparing(ParameterData::getIndex);

        public byte getIndex();

        public @Nullable String getName();

        public @Nullable String getJavadoc();
    }

    public static interface MethodData {
        public static final Comparator<MethodData> COMPARATOR = Comparator.comparing(MethodData::getName).thenComparing(MethodData::getDescriptor);

        public String getName();

        public String getDescriptor();

        public List<String> getJavadoc();

        public Collection<? extends ParameterData> getParameters();

        public @Nullable ParameterData getParameter(byte var1);
    }

    public static interface FieldData {
        public static final Comparator<FieldData> COMPARATOR = Comparator.comparing(FieldData::getName);

        public String getName();

        public String getDescriptor();

        public List<String> getJavadoc();
    }

    public static interface ClassData {
        public static final Comparator<ClassData> COMPARATOR = Comparator.comparing(ClassData::getName);

        public String getName();

        public List<String> getJavadoc();

        public Collection<? extends FieldData> getFields();

        public Collection<? extends MethodData> getMethods();

        public @Nullable FieldData getField(String var1);

        public @Nullable MethodData getMethod(String var1, String var2);
    }

    public static interface PackageData {
        public static final Comparator<PackageData> COMPARATOR = Comparator.comparing(PackageData::getName);

        public String getName();

        public List<String> getJavadoc();
    }
}

