/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.manifests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.manifests.Library;

public class VersionManifest
implements Serializable {
    private final String id;
    private final String type;
    private final int complianceLevel;
    private final int minimumLauncherVersion;
    private final OffsetDateTime time;
    private final OffsetDateTime releaseTime;
    private final String mainClass;
    private final @Nullable JavaVersionInfo javaVersionInfo;
    private final String assets;
    private final AssetIndexInfo assetIndex;
    private final Map<String, DownloadInfo> downloads;
    private final List<Library> libraries;
    private final @Nullable String minecraftArguments;

    public VersionManifest(String id, String type, int complianceLevel, int minimumLauncherVersion, OffsetDateTime time, OffsetDateTime releaseTime, String mainClass, @Nullable JavaVersionInfo javaVersionInfo, String assets, AssetIndexInfo assetIndex, Map<String, DownloadInfo> downloads, List<Library> libraries, @Nullable String minecraftArguments) {
        this.id = id;
        this.type = type;
        this.complianceLevel = complianceLevel;
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.time = time;
        this.releaseTime = releaseTime;
        this.mainClass = mainClass;
        this.javaVersionInfo = javaVersionInfo;
        this.assets = assets;
        this.assetIndex = assetIndex;
        this.downloads = ImmutableMap.copyOf(downloads);
        this.libraries = ImmutableList.copyOf(libraries);
        this.minecraftArguments = minecraftArguments;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public int getComplianceLevel() {
        return this.complianceLevel;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public OffsetDateTime getReleaseTime() {
        return this.releaseTime;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public @Nullable JavaVersionInfo getJavaVersionInfo() {
        return this.javaVersionInfo;
    }

    public String getAssets() {
        return this.assets;
    }

    public AssetIndexInfo getAssetIndex() {
        return this.assetIndex;
    }

    public Map<String, DownloadInfo> getDownloads() {
        return this.downloads;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public @Nullable String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public static class AssetIndexInfo
    extends DownloadInfo {
        private final String id;
        private final int totalSize;

        public AssetIndexInfo(String sha12, int size, String url, String id, int totalSize) {
            super(sha12, size, url);
            this.id = id;
            this.totalSize = totalSize;
        }

        public String getId() {
            return this.id;
        }

        public int getTotalSize() {
            return this.totalSize;
        }
    }

    public static class DownloadInfo
    implements Serializable {
        private final String sha1;
        private final int size;
        private final String url;

        public DownloadInfo(String sha12, int size, String url) {
            this.sha1 = sha12;
            this.size = size;
            this.url = url;
        }

        public String getSHA1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class JavaVersionInfo
    implements Serializable {
        private final String component;
        private final int majorVersion;

        public JavaVersionInfo(String component, int majorVersion) {
            this.component = component;
            this.majorVersion = majorVersion;
        }

        public String getComponent() {
            return this.component;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }
    }
}

