/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.manifests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.manifests.VersionManifest;

public class Library
implements Serializable {
    private final String name;
    private final @Nullable ExtractInfo extract;
    private final LibraryDownloads downloads;
    private final @Nullable NativesInfo natives;
    private final List<Rule> rules;

    public Library(String name, @Nullable ExtractInfo extract, LibraryDownloads downloads, @Nullable NativesInfo natives, List<Rule> rules) {
        this.name = name;
        this.extract = extract;
        this.downloads = downloads;
        this.natives = natives;
        this.rules = ImmutableList.copyOf(rules);
    }

    public String getName() {
        return this.name;
    }

    public @Nullable ExtractInfo getExtract() {
        return this.extract;
    }

    public LibraryDownloads getDownloads() {
        return this.downloads;
    }

    public @Nullable NativesInfo getNatives() {
        return this.natives;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public static class Rule
    implements Serializable {
        private final String action;
        private final @Nullable OSCondition os;

        public Rule(String action2, @Nullable OSCondition os) {
            this.action = action2;
            this.os = os;
        }

        public String getAction() {
            return this.action;
        }

        public @Nullable OSCondition getOS() {
            return this.os;
        }

        public static class OSCondition
        implements Serializable {
            private final String name;
            private final String version;

            public OSCondition(String name, String version) {
                this.name = name;
                this.version = version;
            }

            public String getName() {
                return this.name;
            }

            public String getVersion() {
                return this.version;
            }
        }
    }

    public static class NativesInfo
    implements Serializable {
        private final String linux;
        private final String osx;
        private final String windows;

        public NativesInfo(String linux, String osx, String windows) {
            this.linux = linux;
            this.osx = osx;
            this.windows = windows;
        }

        public String getLinux() {
            return this.linux;
        }

        public String getOSX() {
            return this.osx;
        }

        public String getWindows() {
            return this.windows;
        }
    }

    public static class ExtractInfo
    implements Serializable {
        private final List<String> exclude;

        public ExtractInfo(List<String> exclude) {
            this.exclude = ImmutableList.copyOf(exclude);
        }

        public List<String> getExclude() {
            return this.exclude;
        }
    }

    public static class ArtifactDownload
    extends VersionManifest.DownloadInfo {
        public String path;

        public ArtifactDownload(String sha12, int size, String url, String path) {
            super(sha12, size, url);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class LibraryDownloads
    implements Serializable {
        private final @Nullable ArtifactDownload artifact;
        private final @Nullable Map<String, ArtifactDownload> classifiers;

        public LibraryDownloads(@Nullable ArtifactDownload artifact, @Nullable Map<String, ArtifactDownload> classifiers) {
            this.artifact = artifact;
            this.classifiers = classifiers != null ? ImmutableMap.copyOf(classifiers) : null;
        }

        public @Nullable ArtifactDownload getArtifact() {
            return this.artifact;
        }

        public @Nullable Map<String, ArtifactDownload> getClassifiers() {
            return this.classifiers;
        }
    }
}

