/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.manifests;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LauncherManifest
implements Serializable {
    private final LatestVersionInfo latest;
    private final List<VersionData> versions;

    public LauncherManifest(LatestVersionInfo latest, List<VersionData> versions) {
        this.latest = latest;
        this.versions = ImmutableList.copyOf(versions);
    }

    public LatestVersionInfo getLatest() {
        return this.latest;
    }

    public List<VersionData> getVersions() {
        return this.versions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LauncherManifest that = (LauncherManifest)o;
        return this.getLatest().equals(that.getLatest()) && this.getVersions().equals(that.getVersions());
    }

    public int hashCode() {
        return Objects.hash(this.getLatest(), this.getVersions());
    }

    public static class VersionData
    implements Serializable {
        private final String id;
        private final String type;
        private final String url;
        private final OffsetDateTime time;
        private final OffsetDateTime releaseTime;
        private final String sha1;
        private final int complianceLevel;

        public VersionData(String id, String type, String url, OffsetDateTime time, OffsetDateTime releaseTime, String sha12, int complianceLevel) {
            this.id = id;
            this.type = type;
            this.url = url;
            this.time = time;
            this.releaseTime = releaseTime;
            this.sha1 = sha12;
            this.complianceLevel = complianceLevel;
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public OffsetDateTime getTime() {
            return this.time;
        }

        public OffsetDateTime getReleaseTime() {
            return this.releaseTime;
        }

        public String getSHA1() {
            return this.sha1;
        }

        public int getComplianceLevel() {
            return this.complianceLevel;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionData that = (VersionData)o;
            return this.getComplianceLevel() == that.getComplianceLevel() && this.getId().equals(that.getId()) && this.getType().equals(that.getType()) && this.getUrl().equals(that.getUrl()) && this.getTime().equals(that.getTime()) && this.getReleaseTime().equals(that.getReleaseTime()) && this.getSHA1().equals(that.getSHA1());
        }

        public int hashCode() {
            return Objects.hash(this.getId(), this.getType(), this.getUrl(), this.getTime(), this.getReleaseTime(), this.getSHA1(), this.getComplianceLevel());
        }
    }

    public static class LatestVersionInfo
    implements Serializable {
        private final String release;
        private final String snapshot;

        public LatestVersionInfo(String release, String snapshot) {
            this.release = release;
            this.snapshot = snapshot;
        }

        public String getRelease() {
            return this.release;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LatestVersionInfo that = (LatestVersionInfo)o;
            return this.getRelease().equals(that.getRelease()) && this.getSnapshot().equals(that.getSnapshot());
        }

        public int hashCode() {
            return Objects.hash(this.getRelease(), this.getSnapshot());
        }
    }
}

