/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.List;
import org.jdom.Content;
import org.jdom.Verifier;
import org.jdom.output.AbstractFormattedWalker;
import org.jdom.output.FormatStack;

final class WalkerNORMALIZE
extends AbstractFormattedWalker {
    WalkerNORMALIZE(List<? extends Content> content, FormatStack fstack, boolean escape) {
        super(content, fstack, escape);
    }

    private static boolean isSpaceFirst(String text2) {
        if (!text2.isEmpty()) {
            return Verifier.isXMLWhitespace(text2.charAt(0));
        }
        return false;
    }

    private static boolean isSpaceLast(String text2) {
        int tlen = text2.length();
        return tlen > 0 && Verifier.isXMLWhitespace(text2.charAt(tlen - 1));
    }

    @Override
    protected void analyzeMultiText(AbstractFormattedWalker.MultiText mtext, int offset, int len) {
        boolean needspace = false;
        boolean between = false;
        block4: for (int i = 0; i < len; ++i) {
            Content c = this.get(offset + i);
            switch (c.getCType()) {
                case Text: {
                    String ttext = c.getValue();
                    if (Verifier.isAllXMLWhitespace(ttext)) {
                        if (!between || ttext.isEmpty()) continue block4;
                        needspace = true;
                        continue block4;
                    }
                    if (between && (needspace || WalkerNORMALIZE.isSpaceFirst(ttext))) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendText(AbstractFormattedWalker.Trim.COMPACT, ttext);
                    between = true;
                    needspace = WalkerNORMALIZE.isSpaceLast(ttext);
                    continue block4;
                }
                case CDATA: {
                    String ttext = c.getValue();
                    if (Verifier.isAllXMLWhitespace(ttext)) {
                        if (!between || ttext.isEmpty()) continue block4;
                        needspace = true;
                        continue block4;
                    }
                    if (between && (needspace || WalkerNORMALIZE.isSpaceFirst(ttext))) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendCDATA(AbstractFormattedWalker.Trim.COMPACT, ttext);
                    between = true;
                    needspace = WalkerNORMALIZE.isSpaceLast(ttext);
                    continue block4;
                }
                default: {
                    if (between && needspace) {
                        mtext.appendText(AbstractFormattedWalker.Trim.NONE, " ");
                    }
                    mtext.appendRaw(c);
                    between = true;
                    needspace = false;
                }
            }
        }
    }
}

