/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Parent;
import org.jdom.Verifier;

public final class Comment
extends Content {
    private static final long serialVersionUID = 200L;
    private String text;

    public Comment(String text2) {
        super(Content.CType.Comment);
        this.setText(text2);
    }

    @Override
    public String getValue() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public Comment setText(String text2) {
        String reason = Verifier.checkCommentData(text2);
        if (reason != null) {
            throw new IllegalDataException(text2, "comment", reason);
        }
        this.text = text2;
        return this;
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    @Override
    public Comment detach() {
        return (Comment)super.detach();
    }

    @Override
    protected Comment setParent(Parent parent) {
        return (Comment)super.setParent(parent);
    }

    public String toString() {
        return "[Comment: " + this.text + "]";
    }
}

