/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.parchment.namesanddocs.parchment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsDatabase;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForClass;
import net.neoforged.jst.parchment.namesanddocs.parchment.ParchmentNamesAndDocsForClass;
import org.parchmentmc.feather.io.gson.MDCGsonAdapterFactory;
import org.parchmentmc.feather.io.gson.SimpleVersionAdapter;
import org.parchmentmc.feather.mapping.MappingDataContainer;
import org.parchmentmc.feather.mapping.VersionedMappingDataContainer;
import org.parchmentmc.feather.util.SimpleVersion;

public class ParchmentDatabase
implements NamesAndDocsDatabase {
    private final VersionedMappingDataContainer container;

    public ParchmentDatabase(VersionedMappingDataContainer container) {
        this.container = container;
    }

    @Override
    public NamesAndDocsForClass getClass(String className) {
        MappingDataContainer.ClassData classData = this.container.getClass(className);
        if (classData != null) {
            return new ParchmentNamesAndDocsForClass(classData);
        }
        return null;
    }

    public static ParchmentDatabase loadZip(Path parchmentFile) throws IOException {
        try (ZipFile zf = new ZipFile(parchmentFile.toFile());){
            ParchmentDatabase parchmentDatabase;
            block13: {
                ZipEntry parchmentJsonEntry = zf.getEntry("parchment.json");
                if (parchmentJsonEntry == null) {
                    parchmentJsonEntry = ParchmentDatabase.findFallbackEntryJson(parchmentFile, zf);
                }
                if (parchmentJsonEntry == null || parchmentJsonEntry.isDirectory()) {
                    throw new FileNotFoundException("Could not locate parchment.json at the root of ZIP-File " + String.valueOf(parchmentFile));
                }
                InputStream inputStream = zf.getInputStream(parchmentJsonEntry);
                try {
                    parchmentDatabase = ParchmentDatabase.loadJson(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return parchmentDatabase;
        }
    }

    private static ZipEntry findFallbackEntryJson(Path parchmentFile, ZipFile zf) throws FileNotFoundException {
        Iterator<? extends ZipEntry> entries2 = zf.entries().asIterator();
        ZipEntry parchmentJsonEntry = null;
        while (entries2.hasNext()) {
            ZipEntry entry = entries2.next();
            if (entry.getName().contains("/") || !entry.getName().endsWith(".json")) continue;
            if (parchmentJsonEntry != null) {
                throw new FileNotFoundException("Could not locate parchment.json at the root of ZIP-File " + String.valueOf(parchmentFile) + " and there are multiple other JSON files present in the root.");
            }
            parchmentJsonEntry = entry;
        }
        return parchmentJsonEntry;
    }

    public static ParchmentDatabase loadJson(Path parchmentFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(parchmentFile);){
            ParchmentDatabase parchmentDatabase = ParchmentDatabase.loadJson(reader);
            return parchmentDatabase;
        }
    }

    public static ParchmentDatabase loadJson(Reader reader) {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(new MDCGsonAdapterFactory()).registerTypeAdapter((Type)((Object)SimpleVersion.class), new SimpleVersionAdapter()).create();
        return new ParchmentDatabase(gson.fromJson(reader, VersionedMappingDataContainer.class));
    }
}

