/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.interfaceinjection;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import net.neoforged.jst.interfaceinjection.InjectInterfacesVisitor;
import net.neoforged.jst.interfaceinjection.StubStore;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public class InterfaceInjectionTransformer
implements SourceTransformer {
    private static final Gson GSON = new Gson();
    @CommandLine.Option(names={"--interface-injection-stubs"}, description={"The path to a zip to save interface stubs in"})
    @Nullable
    public Path stubOut;
    @CommandLine.Option(names={"--interface-injection-marker"}, description={"The name (binary representation) of an annotation to use as a marker for injected interfaces"})
    @Nullable
    public String annotationMarker;
    @CommandLine.Option(names={"--interface-injection-data"}, description={"The paths to read interface injection JSON files from"})
    public List<Path> paths = new ArrayList<Path>();
    private MultiMap<String, String> interfaces;
    private StubStore stubs;
    private String marker;

    @Override
    public void beforeRun(TransformContext context2) {
        this.interfaces = new MultiMap();
        this.stubs = new StubStore(context2.logger(), context2.environment().getPsiFacade());
        if (this.annotationMarker != null) {
            this.marker = this.annotationMarker.replace('/', '.').replace('$', '.');
        }
        for (Path path : this.paths) {
            try {
                JsonObject json = GSON.fromJson(Files.readString(path), JsonObject.class);
                for (String clazz : json.keySet()) {
                    JsonElement entry = json.get(clazz);
                    if (entry.isJsonArray()) {
                        entry.getAsJsonArray().forEach(el -> this.interfaces.putValue(clazz, el.getAsString()));
                        continue;
                    }
                    this.interfaces.putValue(clazz, entry.getAsString());
                }
            }
            catch (IOException exception) {
                context2.logger().error("Failed to read interface injection data file: %s", exception.getMessage());
                throw new UncheckedIOException(exception);
            }
        }
    }

    @Override
    public boolean afterRun(TransformContext context2) {
        if (this.stubOut != null) {
            try {
                this.stubs.save(this.stubOut);
            }
            catch (IOException e) {
                context2.logger().error("Failed to save stubs: %s", e.getMessage());
                throw new UncheckedIOException(e);
            }
        }
        return true;
    }

    @Override
    public void visitFile(PsiFile psiFile, Replacements replacements) {
        new InjectInterfacesVisitor(replacements, this.interfaces, this.stubs, this.marker).visitFile(psiFile);
    }
}

