/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.intellij;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.neoforged.jst.cli.intellij.CoreJrtFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CoreJrtVirtualFile
extends VirtualFile {
    private final CoreJrtFileSystem virtualFileSystem;
    private final String jdkHomePath;
    private final Path path;
    private final CoreJrtVirtualFile parent;
    @Nullable
    private VirtualFile[] myChildren = null;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();

    public CoreJrtVirtualFile(CoreJrtFileSystem virtualFileSystem, String jdkHomePath, Path path, CoreJrtVirtualFile parent) {
        this.virtualFileSystem = virtualFileSystem;
        this.jdkHomePath = jdkHomePath;
        this.path = path;
        this.parent = parent;
    }

    private BasicFileAttributes getAttributes() {
        try {
            return Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.virtualFileSystem;
    }

    @Override
    @NotNull
    public String getName() {
        return this.path.getFileName().toString();
    }

    @Override
    @NonNls
    @NotNull
    public String getPath() {
        return FileUtil.toSystemIndependentName(this.jdkHomePath + "!/" + String.valueOf(this.path));
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        return this.parent;
    }

    @Override
    public VirtualFile[] getChildren() {
        this.rwl.readLock().lock();
        try {
            if (this.myChildren != null) {
                VirtualFile[] virtualFileArray = this.myChildren;
                return virtualFileArray;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.rwl.writeLock().lock();
        try {
            if (this.myChildren == null) {
                this.myChildren = this.computeChildren();
            }
            VirtualFile[] virtualFileArray = this.myChildren;
            return virtualFileArray;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private VirtualFile[] computeChildren() {
        ArrayList<CoreJrtVirtualFile> paths2 = new ArrayList<CoreJrtVirtualFile>();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.path);){
            for (Path childPath : dirStream) {
                paths2.add(new CoreJrtVirtualFile(this.virtualFileSystem, this.jdkHomePath, childPath, this));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (paths2.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return paths2.toArray(new VirtualFile[0]);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        return Files.readAllBytes(this.path);
    }

    @Override
    public long getTimeStamp() {
        return this.getAttributes().lastModifiedTime().toMillis();
    }

    @Override
    public long getLength() {
        return this.getAttributes().size();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0])), this);
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CoreJrtVirtualFile)) return false;
        CoreJrtVirtualFile jrtVf = (CoreJrtVirtualFile)obj;
        if (this.path != jrtVf.path) return false;
        if (this.virtualFileSystem != jrtVf.virtualFileSystem) return false;
        return true;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

