/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectLongHashMap;
import java.util.ConcurrentModificationException;

public final class TObjectLongIterator<K>
extends TIterator {
    private final TObjectLongHashMap<K> _map;

    public TObjectLongIterator(TObjectLongHashMap<K> map2) {
        super(map2);
        this._map = map2;
    }

    @Override
    protected int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public long value() {
        return this._map._values[this._index];
    }

    public long setValue(long val) {
        long old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

