/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.constantmappers.datadriven.parser.v3;

import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupScope;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionTransformer;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class UnpickV3Remapper
extends UnpickV3Visitor {
    private final UnpickV3Visitor downstream;

    public UnpickV3Remapper(UnpickV3Visitor downstream) {
        this.downstream = downstream;
    }

    @Override
    public void visitGroupDefinition(GroupDefinition groupDefinition) {
        List scopes = groupDefinition.scopes().stream().flatMap(scope -> {
            String patt9$temp;
            String patt8$temp;
            String className2;
            GroupScope groupScope = scope;
            Objects.requireNonNull(groupScope);
            GroupScope selector3$temp = groupScope;
            int index$4 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupScope.Package.class, GroupScope.Class.class, GroupScope.Method.class}, (Object)selector3$temp, index$4)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    String patt5$temp;
                    GroupScope.Package $b$0 = (GroupScope.Package)selector3$temp;
                    String packageName = patt5$temp = $b$0.packageName();
                    return this.getClassesInPackage(packageName).stream().map(className -> new GroupScope.Class(this.mapClassName((String)className)));
                }
                case 1: {
                    String patt6$temp;
                    GroupScope.Class $b$1 = (GroupScope.Class)selector3$temp;
                    String className3 = patt6$temp = $b$1.className();
                    return Stream.of(new GroupScope.Class(this.mapClassName(className3)));
                }
                case 2: 
            }
            GroupScope.Method $b$2 = (GroupScope.Method)selector3$temp;
            try {
                String patt7$temp;
                className2 = patt7$temp = $b$2.className();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            String methodName = patt8$temp = $b$2.methodName();
            String methodDesc = patt9$temp = $b$2.methodDesc();
            String newClassName = this.mapClassName(className2);
            String newMethodName = this.mapMethodName(className2, methodName, methodDesc);
            String newMethodDesc = this.mapDescriptor(methodDesc);
            return Stream.of(new GroupScope.Method(newClassName, newMethodName, newMethodDesc));
        }).toList();
        List<Expression> constants = groupDefinition.constants().stream().map(constant -> constant.transform(new ExpressionRemapper())).toList();
        this.downstream.visitGroupDefinition(GroupDefinition.Builder.from(groupDefinition).setScopes(scopes).setConstants(constants).build());
    }

    @Override
    public void visitTargetField(TargetField targetField) {
        String className = this.mapClassName(targetField.className());
        String fieldName = this.mapFieldName(targetField.className(), targetField.fieldName(), targetField.fieldDesc());
        String fieldDesc = this.mapDescriptor(targetField.fieldDesc());
        this.downstream.visitTargetField(new TargetField(className, fieldName, fieldDesc, targetField.groupName()));
    }

    @Override
    public void visitTargetMethod(TargetMethod targetMethod) {
        String className = this.mapClassName(targetMethod.className());
        String methodName = this.mapMethodName(targetMethod.className(), targetMethod.methodName(), targetMethod.methodDesc());
        String methodDesc = this.mapDescriptor(targetMethod.methodDesc());
        this.downstream.visitTargetMethod(new TargetMethod(className, methodName, methodDesc, targetMethod.paramGroups(), targetMethod.returnGroup()));
    }

    protected abstract String mapClassName(String var1);

    protected abstract String mapFieldName(String var1, String var2, String var3);

    protected abstract String mapMethodName(String var1, String var2, String var3);

    protected abstract List<String> getClassesInPackage(String var1);

    protected abstract String getFieldDesc(String var1, String var2);

    private String mapDescriptor(String descriptor2) {
        int lIndex;
        StringBuilder mappedDescriptor = new StringBuilder();
        int semicolonIndex = 0;
        while ((lIndex = descriptor2.indexOf(76, semicolonIndex)) != -1) {
            mappedDescriptor.append(descriptor2, semicolonIndex, lIndex + 1);
            semicolonIndex = descriptor2.indexOf(59, lIndex);
            if (semicolonIndex == -1) {
                throw new AssertionError((Object)("Invalid descriptor: " + descriptor2));
            }
            String className = descriptor2.substring(lIndex + 1, semicolonIndex).replace('/', '.');
            mappedDescriptor.append(this.mapClassName(className).replace('.', '/'));
        }
        return mappedDescriptor.append(descriptor2, semicolonIndex, descriptor2.length()).toString();
    }

    private class ExpressionRemapper
    extends ExpressionTransformer {
        private ExpressionRemapper() {
        }

        @Override
        public Expression transformFieldExpression(FieldExpression fieldExpression) {
            String fieldDesc;
            String className = UnpickV3Remapper.this.mapClassName(fieldExpression.className);
            if (fieldExpression.fieldName == null) {
                return new FieldExpression(className, null, fieldExpression.fieldType, fieldExpression.isStatic);
            }
            if (fieldExpression.fieldType == null) {
                fieldDesc = UnpickV3Remapper.this.getFieldDesc(fieldExpression.className, fieldExpression.fieldName);
            } else {
                fieldDesc = switch (fieldExpression.fieldType) {
                    default -> throw new MatchException(null, null);
                    case DataType.BYTE -> "B";
                    case DataType.SHORT -> "S";
                    case DataType.INT -> "I";
                    case DataType.LONG -> "J";
                    case DataType.FLOAT -> "F";
                    case DataType.DOUBLE -> "D";
                    case DataType.CHAR -> "C";
                    case DataType.STRING -> "Ljava/lang/String;";
                    case DataType.CLASS -> "Ljava/lang/Class;";
                };
            }
            String fieldName = UnpickV3Remapper.this.mapFieldName(fieldExpression.className, fieldExpression.fieldName, fieldDesc);
            return new FieldExpression(className, fieldName, fieldExpression.fieldType, fieldExpression.isStatic);
        }
    }
}

